#include "mbed.h"
#include "MARMEX_OB_oled.h"
#include "lcharmap.h"

//"LCHAR_HEIGHT", "LCHAR_WIDTH" -> "lcharmap.h"
DigitalOut myled(LED1);
MARMEX_OB_oled   oled1( p5, p7,  p8, p30, p11 ); // mosi, sclk, cs, rst, power_control

void strscroll(char *str, int len);
void arraycopy(char array1[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN],char array2[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN]);
void arraycopy2(char array1[][LCHAR_HEIGHT][LCHAR_WIDTH],char array2[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN], int n);

int main()
{
    oled1.background( 0x000000 );
    oled1.cls();
    char str[]={"ABC abc"};//input massage
    strscroll(str,strlen(str));

}

void strscroll(char *str, int len)
{
    char left[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN],
         center[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN],
         right[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN];
    arraycopy2(map_mark,left,0);
    arraycopy2(map_mark,center,0);

    for(int i=0; i<len+2; i++) {
        if(i>=len)arraycopy2(map_mark,right,0);
        else if('A'<=str[i]&&str[i]<='Z')arraycopy2(map_large,right,str[i]-'A');
        else if('a'<=str[i]&&str[i]<='z')arraycopy2(map_small,right,str[i]-'a');
        else if('0'<=str[i]&&str[i]<='9')arraycopy2(map_number,right,str[i]-'0');
        else if(str[i]==32)arraycopy2(map_mark,right,0);
        else if(str[i]==',')arraycopy2(map_mark,right,1);
        else if(str[i]=='.')arraycopy2(map_mark,right,2);
        else oled1.cls(),myled=1,strscroll("ERROR", strlen("ERROR")),exit(EXIT_FAILURE);

        for(int x=15; x>=15-(LCHAR_WIDTH+MARGIN); x--) {
            for(int k=0; k<(LCHAR_WIDTH+MARGIN); k++) {
                for(int y=0; y<LCHAR_HEIGHT; y++) {
                    int color;

                    //left
                    if(left[y][k]==1)color=0xFFFFFF;
                    else color=0x000000;
                    if(0<=x+k-(LCHAR_WIDTH+MARGIN)*2&&x+k-(LCHAR_WIDTH+MARGIN)*2<=15)oled1.fill((x+k-(LCHAR_WIDTH+MARGIN)*2)*8,y*8,8,8,color);

                    //center
                    if(center[y][k]==1)color=0xFFFFFF;
                    else color=0x000000;
                    if(0<=x+k-(LCHAR_WIDTH+MARGIN)&&x+k-(LCHAR_WIDTH+MARGIN)<=15)oled1.fill((x+k-(LCHAR_WIDTH+MARGIN))*8,y*8,8,8,color);

                    //right
                    if(right[y][k]==1)color=0xFFFFFF;
                    else color=0x000000;
                    if(0<=x+k&&x+k<=15)oled1.fill((x+k)*8,y*8,8,8,color);
                }
            
            }
        if(x!=15-(LCHAR_WIDTH+MARGIN))wait(0.1);
        }
    arraycopy(center,left);
    arraycopy(right,center);
    }
    

}

void arraycopy(char array1[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN],char array2[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN]){
    for(int i=0; i<LCHAR_HEIGHT; i++)for(int j=0; j<LCHAR_WIDTH; j++)array2[i][j]=array1[i][j];
}

void arraycopy2(char array1[][LCHAR_HEIGHT][LCHAR_WIDTH],char array2[LCHAR_HEIGHT][LCHAR_WIDTH+MARGIN], int n){
    for(int i=0; i<LCHAR_HEIGHT; i++)for(int j=0; j<LCHAR_WIDTH+MARGIN; j++){
        if(j>=LCHAR_WIDTH)array2[i][j]=0;
        else array2[i][j]=array1[n][i][j];
    }
}