#include "lcharmap.h"

/*template
char map_*****[*][LCHAR_HEIGHT][LCHAR_WIDTH]={
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0},
     
     ...
     
     },
*/

/*
map_large:Capital letters([0][][]->A,...,[25][][]->Z)
map_small:Small letters([0][][]->a,...,[25][][]->z)
map_number:Numbers([0]->0,...,[9]->9)
map_mark:mark, space, etc.([0]->(space),[1]->(comma), [2]->(period))
*/
char map_large[26][LCHAR_HEIGHT][LCHAR_WIDTH]={
    //A
    {0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,1,1,1,1,1,1,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1},
     
     //B
    {1,1,1,1,1,1,0,0,0,0,
     1,0,0,0,0,0,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,1,0,0,0,
     1,1,1,1,1,1,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,1,0,0,
     1,1,1,1,1,1,1,0,0,0},
     
     //C
    {0,0,0,1,1,1,1,1,0,0,
     0,0,1,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,1,
     0,0,1,0,0,0,0,0,1,0,
     0,0,0,1,1,1,1,1,0,0},
     
     //D
    {1,1,1,1,0,0,0,0,0,0,
     1,0,0,0,1,1,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,1,1,1,0,0,0,
     1,1,1,1,0,0,0,0,0,0},
     
     //E
    {1,1,1,1,1,1,1,1,1,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1},
     
     //F
    {1,1,1,1,1,1,1,1,1,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0},
     
     //G
    {0,0,0,1,1,1,1,1,0,0,
     0,0,1,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,1,1,1,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,1,
     0,0,1,0,0,0,0,1,0,1,
     0,0,0,1,1,1,1,0,0,1},
     
     //H
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,1,1,1,1,1,1,1,1,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1},
     
     //I
    {0,0,1,1,1,1,1,1,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,1,1,1,1,1,1,0,0},
     
     //J
    {0,0,1,1,1,1,1,1,1,1,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,1,0,0,
     0,1,0,0,0,0,1,0,0,0,
     0,0,1,1,1,1,0,0,0,0},
     
     //K
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,1,0,0,0,
     1,0,0,0,0,1,0,0,0,0,
     1,0,0,0,1,0,0,0,0,0,
     1,0,0,1,0,0,0,0,0,0,
     1,0,1,0,0,0,0,0,0,0,
     1,1,1,0,0,0,0,0,0,0,
     1,0,0,1,0,0,0,0,0,0,
     1,0,0,0,1,0,0,0,0,0,
     1,0,0,0,0,1,0,0,0,0,
     1,0,0,0,0,0,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1},
     
     //L
    {1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1},
     
     //M
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,1,0,0,0,0,0,0,1,1,
     1,1,0,0,0,0,0,0,1,1,
     1,1,0,0,0,0,0,0,1,1,
     1,0,1,0,0,0,0,1,0,1,
     1,0,1,0,0,0,0,1,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1},
     
     //N
    {1,0,0,0,0,0,0,0,0,1,
     1,1,0,0,0,0,0,0,0,1,
     1,1,0,0,0,0,0,0,0,1,
     1,0,1,0,0,0,0,0,0,1,
     1,0,1,0,0,0,0,0,0,1,
     1,0,0,1,0,0,0,0,0,1,
     1,0,0,0,1,0,0,0,0,1,
     1,0,0,0,1,0,0,0,0,1,
     1,0,0,0,0,1,0,0,0,1,
     1,0,0,0,0,1,0,0,0,1,
     1,0,0,0,0,0,1,0,0,1,
     1,0,0,0,0,0,0,1,0,1,
     1,0,0,0,0,0,0,1,0,1,
     1,0,0,0,0,0,0,0,1,1,
     1,0,0,0,0,0,0,0,1,1,
     1,0,0,0,0,0,0,0,0,1},
     
     //O
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //P
    {1,1,1,1,1,1,1,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     1,1,1,1,1,1,1,1,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0},
     
     //Q
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,1,1,0,0,1,0,
     0,1,0,1,0,0,1,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,1,1},
     
     //R
    {1,1,1,1,1,1,1,0,0,0,
     1,0,0,0,0,0,0,1,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,1,1,0,
     1,1,1,1,1,1,1,0,0,0,
     1,0,1,0,0,0,0,0,0,0,
     1,0,0,1,0,0,0,0,0,0,
     1,0,0,0,1,0,0,0,0,0,
     1,0,0,0,0,1,0,0,0,0,
     1,0,0,0,0,0,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1},
     
     //S
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //T
    {1,1,1,1,1,1,1,1,1,1,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0},
     
     //U
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
    
     //V
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0},
     
     //W
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,1,0,0,0,0,1,0,1,
     1,0,1,0,0,0,0,1,0,1,
     1,0,1,0,0,0,0,1,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0},
     
     //X
    {1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1},
     
     //Y
    {1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0},
     
     //Z    
    {1,1,1,1,1,1,1,1,1,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,1,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1}
};

char map_small[26][LCHAR_HEIGHT][LCHAR_WIDTH]={
    //a
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,1,1,1,1,1,1,0,0,0,
     1,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,1,1,1,1,0,1,0,0,
     0,1,0,0,0,0,1,1,0,0,
     1,0,0,0,0,0,0,1,0,0,
     1,0,0,0,0,0,0,1,0,0,
     0,1,0,0,0,0,1,0,1,0,
     0,0,1,1,1,1,0,0,0,1},
     
    //b
    {1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,1,1,1,1,0,0,0,
     1,1,1,0,0,0,0,1,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,1,1,0,0,0,0,1,1,0,
     1,0,0,1,1,1,1,0,0,0},
     
    //c
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,1,1,1,1,1,0,0,
     0,0,1,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,1,
     0,0,1,0,0,0,0,0,1,0,
     0,0,0,1,1,1,1,1,0,0},
     
    //d
    {0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,1,1,1,1,0,0,1,
     0,1,1,0,0,0,0,1,1,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,1,0,0,0,0,1,1,1,
     0,0,0,1,1,1,1,0,0,1},
     
    //e
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,1,1,1,1,1,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,1,1,1,1,1,1,1,1,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,1,1,1,1,1,0,0},
     
    //f
    {0,0,0,0,0,1,1,1,0,0,
     0,0,0,0,1,0,0,0,1,0,
     0,0,0,1,0,0,0,0,0,1,
     0,0,0,1,0,0,0,0,0,1,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0},
     
    //g
    {0,0,0,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     0,0,1,1,1,1,1,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,1,1,1,1,1,0,0},
     
    //h
    {1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,1,1,1,1,0,0,0,
     1,0,1,0,0,0,0,1,0,0,
     1,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1},
     
    //i
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0},
     
    //j
    {0,0,0,0,0,0,0,0,1,1,
     0,0,0,0,0,0,0,0,1,1,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,1,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
    //k
    {1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,1,1,0,
     1,0,0,0,0,1,1,0,0,0,
     1,0,0,1,1,0,0,0,0,0,
     1,1,1,0,0,1,0,0,0,0,
     1,0,0,0,0,0,1,1,0,0,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1},
     
    //l
    {0,0,0,1,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
    //m
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,1,1,0,0,1,1,0,0,
     1,1,0,0,1,1,0,0,1,0,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1},
     
    //n
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,1,1,1,1,1,0,0,
     1,0,1,0,0,0,0,0,1,0,
     1,1,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1},
     
    //o
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
    //p
    {1,0,0,1,1,1,1,0,0,0,
     1,1,1,0,0,0,0,1,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,1,1,0,0,0,0,1,1,0,
     1,0,0,1,1,1,1,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0},
     
    //q
    {0,0,0,1,1,1,1,0,0,1,
     0,1,1,0,0,0,0,1,1,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,1,0,0,0,0,1,1,1,
     0,0,0,1,1,1,1,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1},
     
    //r
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,1,1,1,1,0,0,0,
     1,0,1,0,0,0,0,1,1,0,
     1,1,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0},
     
    //s
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,1,1,1,1,1,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,0,0,
     0,0,1,1,1,1,1,1,0,0,
     0,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,1,1,1,1,1,0,0},
     
    //t
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     1,1,1,1,1,1,1,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,1,
     0,0,0,1,0,0,0,0,0,1,
     0,0,0,1,0,0,0,0,1,0,
     0,0,0,0,1,1,1,1,0,0},
     
    //u
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,1,
     0,1,1,0,0,0,0,1,0,1,
     0,0,0,1,1,1,1,0,0,1},
     
    //v
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0},
     
    //w
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,0,1,1,0,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,0,1,0,0,1,0,0,1,
     1,0,1,0,0,0,0,1,0,1,
     1,0,1,0,0,0,0,1,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0},
     
    //x
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,1,0,0,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1},
     
    //y
    {1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,0,1,0,
     0,0,0,1,0,0,0,1,0,0,
     0,0,0,1,0,0,0,1,0,0,
     0,0,0,0,1,0,1,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0},
     
    //z
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,1,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1}
};
    
char map_number[10][LCHAR_HEIGHT][LCHAR_WIDTH]={
    //0
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,1,1,0,
     1,0,0,0,0,0,1,0,0,1,
     1,0,0,0,0,1,0,0,0,1,
     1,0,0,0,1,0,0,0,0,1,
     1,0,0,0,1,0,0,0,0,1,
     1,0,0,1,0,0,0,0,0,1,
     1,0,1,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //1
    {0,0,0,0,1,1,0,0,0,0,
     0,0,0,1,1,1,0,0,0,0,
     0,0,1,1,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,0,0,0,1,1,0,0,0,0,
     0,1,1,1,1,1,1,1,1,0},
     
     //2
    {0,0,1,1,1,1,1,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,1,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1},
     
     //3
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //4
    {0,0,1,0,0,1,0,0,0,0,
     0,0,1,0,0,1,0,0,0,0,
     0,0,1,0,0,1,0,0,0,0,
     0,1,0,0,0,1,0,0,0,0,
     0,1,0,0,0,1,0,0,0,0,
     0,1,0,0,0,1,0,0,0,0,
     0,1,0,0,0,1,0,0,0,0,
     0,1,0,0,0,1,0,0,0,0,
     1,0,0,0,0,1,0,0,0,0,
     1,0,0,0,0,1,0,0,0,0,
     1,1,1,1,1,1,1,1,1,1,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0},
     
     //5
    {1,1,1,1,1,1,1,1,1,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,1,1,1,1,1,1,0,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,1,0,0,
     0,1,1,1,1,1,1,0,0,0},
     
     //6
    {0,0,0,1,1,1,1,0,0,0,
     0,1,1,0,0,0,0,1,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,0,0,0,0,0,0,0,
     1,0,0,1,1,1,1,0,0,0,
     1,0,1,0,0,0,0,1,0,0,
     1,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //7
    {1,1,1,1,1,1,1,1,1,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,1,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,0,1,0,0,
     0,0,0,0,0,0,1,0,0,0,
     0,0,0,0,0,0,1,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,0,1,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,0,1,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0,
     0,0,0,1,0,0,0,0,0,0},
     
     //8
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,0,
     0,0,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0},
     
     //9
    {0,0,0,1,1,1,1,0,0,0,
     0,0,1,0,0,0,0,1,0,0,
     0,1,0,0,0,0,0,0,1,0,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,0,1,
     0,1,0,0,0,0,0,0,1,1,
     0,0,1,0,0,0,0,1,0,1,
     0,0,0,1,1,1,1,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     0,0,0,0,0,0,0,0,0,1,
     1,0,0,0,0,0,0,0,1,0,
     0,1,1,0,0,0,0,1,0,0,
     0,0,0,1,1,1,1,0,0,0}
};

char map_mark[3][LCHAR_HEIGHT][LCHAR_WIDTH]={
    //space
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0},
     
     //comma
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,1,1,0,0,0,0,0,0,0,
     0,1,1,0,0,0,0,0,0,0,
     0,0,1,0,0,0,0,0,0,0,
     0,1,0,0,0,0,0,0,0,0},
     
     //period
    {0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,0,0,0,0,0,0,0,0,0,
     0,1,1,0,0,0,0,0,0,0,
     0,1,1,0,0,0,0,0,0,0},
};