#ifndef MBED_MIDI
#define MBED_MIDI

#include "mbed.h"
#include <list>

class midi {
    public:
        midi(PinName _bzr);
        //~midi();
        void read(const char *path);
        void play(/*int repeat*/);
        void play_realtime(const char *path/*, int repeat*/);
        
    private:
        list<int> tm;//tempo
        //list<int> ev;
        list<char> ca;//channel
        list<float> fq;//frequency
        //list<float> vo;
        list<int> no;//note
        list<char>::iterator pch;
        list<int>::iterator pi;
        list<float>::iterator pf;
        list<int>::iterator pn;
        Timer t;
        PinName bzr;
        int chmax;
        char *path_c;
        unsigned short int tracks;
        unsigned short int crochet;
        long int tempo;
        double freq[12];
        double *table;  
        template<class X>
        void change_endian(X *raw,int byte);
        int powi(int a);
};
#endif