#include "mbed.h"
#include "Adafruit_GFX.h"

#ifndef _BV
#define _BV(bit) (1<<(bit))
#endif

#ifdef DEBUG
#define log_debug(format,...)   std::printf(format,##__VA_ARGS__)
#else
#define log_debug(...)
#endif

class RGBmatrixPanel : public Adafruit_GFX
{

public:
    // Constructor for 16x32 panel:
    RGBmatrixPanel(PinName r1,PinName g1,PinName b1,PinName r2,PinName g2,PinName b2,PinName a,PinName b,PinName c,PinName sclk,PinName latch,PinName oe, bool dbuf);
//    RGBmatrixPanel(PinName r1,PinName r2,PinName g1,PinName g2,PinName b1,PinName b2,PinName a,PinName b,PinName c,PinName sclk,PinName latch,PinName oe,bool dbuf);

    // Constructor for 32x32 panel (adds 'd' pin):
    //RGBmatrixPanel(PinName r1,PinName r2,PinName g1,PinName g2,PinName b1,PinName b2,PinName a,PinName b,PinName c,PinName d,PinName sclk, PinName latch,PinName oe,bool dbuf);

    void begin(void);
    virtual void drawPixel(int16_t x, int16_t y, uint16_t c);
    virtual void fillScreen(uint16_t c);
    void updateDisplay(void);
    void swapBuffers(bool);
    void dumpMatrix(void);

    uint8_t *backBuffer(void);

    uint16_t Color333(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color444(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color888(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color888(uint8_t r, uint8_t g, uint8_t b, bool gflag);
    uint16_t ColorHSV(long hue, uint8_t sat, uint8_t val, bool gflag);

private:
    uint8_t *matrixbuff[2];
    uint8_t nRows;
    uint8_t backindex;
    bool swapflag;

    // Init/alloc code common to both constructors:
    void init(uint8_t rows, bool dbuf);

    BusOut _dataBus;
    BusOut _rowBus;
    DigitalOut _d,_sclk, _latch, _oe;
    Ticker _refresh;
    // Counters/pointers for interrupt handler:
    volatile uint8_t row, plane;
    volatile uint8_t *buffptr;
};