//ATTENTION
//1.This library needs "Display" library(https://mbed.org/users/hornfeldt/code/Display/).
//2.This library only supports 1-bit depth BMP file(monochrome BMP file).

#ifndef BITMAP_KS0107
#define BITMAP_KS0107

#include "mbed.h"
#include "Display.h"

class Bitmap_KS0107 {
    public:
        Bitmap_KS0107(Display *d,int sx,int sy,int w,int h);//argument:pointer to Display(class) object,the x-coordinate of top left of drawing area,the y-coordinate of top left of drawing area,the width of drawing area, the height of drawing area
        void setpos(int sx,int sy,int w,int h);//change drawing areas(argument:the x-coordinate of top left of drawing area,the y-coordinate of top left of drawing area,the width of drawing area, the height of drawing area)
        void read(const char *filename);//argument:filepath of a bitmap file
        void print();//print the picture to the drawing area
        //void print_zoom(int rate);//unimplemented
        
        
    private:
        int start_x;
        int start_y;
        int width;
        int height;
        int bmp_x;
        int bmp_y;
        char **bmp_data;
        Display *disp;
};
#endif