#include "Bitmap_KS0107.h"

Bitmap_KS0107::Bitmap_KS0107(Display *d,int sx,int sy,int w,int h){
    start_x=sx;
    start_y=sy;
    width=w;
    height=h;
    bmp_x=0;
    bmp_y=0;
    bmp_data=NULL;
    disp=d;
}

void Bitmap_KS0107::setpos(int sx,int sy,int w,int h){
    start_x=sx;
    start_y=sy;
    width=w;
    height=h;
}

void Bitmap_KS0107::read(const char *filename){
    FILE *fp;
    char buf[8];
    int offbits;
    
    if(bmp_data!=NULL){
        for (int i= 0; i<bmp_y/8; ++i)delete[] bmp_data[i];
        delete[] bmp_data;
    }
    
    if((fp = fopen(filename, "rb")) == NULL);
    fseek(fp, 10, SEEK_SET);
    fread(&offbits,4,1,fp);
    
    fseek(fp,18, SEEK_SET);
    fread(&bmp_x,4,1,fp);
    
    fseek(fp, 22, SEEK_SET);
    fread(&bmp_y,4,1,fp);
    
    if((bmp_x%4)!=0)bmp_x=((bmp_x/32)+1)*32;
    if((bmp_y%8)!=0)bmp_y=(bmp_y/8)*8;
    bmp_data= new char*[bmp_y/8];
    
    for (int i= 0; i<bmp_y/8; ++i)bmp_data[i]= new char[bmp_x];
    
    for(int i=0;i<bmp_y/8;i++)for(int j=0;j<bmp_x;j++)bmp_data[i][j]=0;
    
    for(int y=0; y<bmp_y/8; y++)for(int x=0; x<bmp_x/8; x++) {
            for(int y_buf=0; y_buf<8; y_buf++) {
                fseek(fp,offbits+(bmp_x/8)*(bmp_y-1)-(bmp_x/8)*y*8-(bmp_x/8)*y_buf+x,SEEK_SET);
                fread(&buf[y_buf],1,1,fp);
            }
            int i,j,bit,add;
            for(bit=1,i=0; i<8; i++,bit=bit<<1)for(add=1, j=0; j<8; j++,add=add<<1)if(buf[j]&bit)bmp_data[y][x*8+7-i]+=add;
    };
    
    fclose(fp);
    
}
void Bitmap_KS0107::print(){
    for(int row=start_x; row<width+start_x; row++)for(int line=start_y/8; line<height/8+start_y/8; line++)disp->write(line,row,bmp_data[line][row]);
}

/*
void Bitmap_KS0107::print_zoom(int rate){
    //unimplemented
}
*/