#ifndef AE_KXSD9_H
#define AE_KXSD9_H
 
#include "mbed.h"

class AE_KXSD9        
{        
    public:
        AE_KXSD9(PinName sda, PinName scl, int addr1, int addr2);//constructor
        //~AE_KXSD9();//destructor(unimplemented)
        void init();//initialization(set to default settings)
        void read_xyz(double *x, double *y, double *z);//read each axial acceleration(unit:g)
        double read_x();//read the acceleration in x-axis(unit:g)
        double read_y();//read the acceleration in y-axis(unit:g)
        double read_z();//read the acceleration in z-axis(unit:g)
        char read_reg(char addr);//read register
        void write_reg(char addr, char data); //write register
        enum{
            XOUT_H=0x00,    //the highest 8 bits of the acceleration in x-axis
            XOUT_L=0x01,    //the lowest 4 bits of the acceleration in x-axis
            YOUT_H=0x02,    //the highest 8 bits of the acceleration in y-axis
            YOUT_L=0x03,    //the lowest 4 bits of the acceleration in y-axis
            ZOUT_H=0x04,   //the highest 8 bits of the acceleration in z-axis
            ZOUT_L=0x05,    //the lowest 4 bits of the acceleration in z-axis
            AUXOUT_H=0x06,    
            AUXOUT_L=0x07,    
            RESET_WRITE=0x0A,    
            CTRL_REGC=0x0C,    
            CTRL_REGB=0x0D,    
            CTRL_REGA=0x0E,  
            SENSITIVITY=273, //tune it yourself(default:273(+-6g))
            OFFSET=2048//tune it yourself(default:2048)
        };
    private:
      I2C i2c_k;
      int addr_w, addr_r;
};

#endif 