#include "AE_KXSD9.h"

//constructor
AE_KXSD9::AE_KXSD9(PinName sda, PinName scl, int addr1, int addr2)
    :i2c_k(sda, scl),
     addr_w(addr1),
     addr_r(addr2)
{};


//destructor
/*
AE_KXSD9::~AE_KXSD9()
{
    
}
*/

//initialization(default setting)
void AE_KXSD9::init()
{
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(0x0C);//register address:CTRL_REGC
    i2c_k.write(0xE1);//data:Reset Value
    i2c_k.stop();
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(0x0D);//register address:CTRL_REGB
    i2c_k.write(0x40);//data:Reset Value
    i2c_k.stop();
}


//read each axial acceleration(unit:g)
void AE_KXSD9::read_xyz(double *x, double *y, double *z)
{
    const char addr_x_h = XOUT_H;
    char data[6] = {};
    short int acc[3]={};
    
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr_x_h);
    wait_us(200);
    i2c_k.start();
    i2c_k.write(addr_r);
    for(int i=0;i<5;i++)data[i]=i2c_k.read(1);//acknowledge(ACK)
    data[5]=i2c_k.read(0);//not acknowledge(NACK)
    i2c_k.stop();
    
    for(int i=0;i<6;i+=2)acc[i/2]=((short int)data[i] << 4) + ((short int)data[i] >> 4) - OFFSET;
    
    *x = ((double)acc[0])/SENSITIVITY;
    *y = ((double)acc[1])/SENSITIVITY;
    *z = ((double)acc[2])/SENSITIVITY; 
}


//read the acceleration in x-axis(unit:g)
double AE_KXSD9::read_x()
{
    const char addr_x_h = XOUT_H;
    char data[2] = {};
    short int acc;
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr_x_h);
    wait_us(200);
    i2c_k.start();
    i2c_k.write(addr_r);
    data[0]=i2c_k.read(1);//acknowledge(ACK)
    data[1]=i2c_k.read(0);//not acknowledge(NACK)
    i2c_k.stop();
    acc=((short int)data[0] << 4) + ((short int)data[1] >> 4) - OFFSET;
    return (double)acc/SENSITIVITY;  
}


//read the acceleration in y-axis(unit:g)
double AE_KXSD9::read_y()
{
    const char addr_y_h = YOUT_H;
    char data[2] = {};
    short int acc;
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr_y_h);
    wait_us(200);
    i2c_k.start();
    i2c_k.write(addr_r);
    data[0]=i2c_k.read(1);//acknowledge(ACK)
    data[1]=i2c_k.read(0);//not acknowledge(NACK)
    i2c_k.stop();
    acc=((short int)data[0] << 4) + ((short int)data[1] >> 4) - OFFSET;
    return (double)acc/SENSITIVITY;  
}


//read the acceleration in z-axis(unit:g)
double AE_KXSD9::read_z()
{

    const char addr_z_h = ZOUT_H;
    char data[2] = {0,0};
    short int acc;
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr_z_h);
    wait_us(200);
    i2c_k.start();
    i2c_k.write(addr_r);
    data[0]=i2c_k.read(1);//acknowledge(ACK)
    data[1]=i2c_k.read(0);//not acknowledge(NACK)
    i2c_k.stop();
    acc=((short int)data[0] << 4) + ((short int)data[1] >> 4) - OFFSET;
    return (double)acc/SENSITIVITY;  
}


//read register
char AE_KXSD9::read_reg(char addr)
{
    char data;
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr);
    i2c_k.start();
    i2c_k.write(addr_r);
    data=i2c_k.read(0);//not acknowledge
    i2c_k.stop();
    return data;
}


//write register
void AE_KXSD9::write_reg(char addr, char data)
{
    i2c_k.start();
    i2c_k.write(addr_w);
    i2c_k.write(addr);
    i2c_k.write(data);
    i2c_k.stop();
}
