#include "mbed.h"
#include "DS18B20.h"
#include "OneWireDefs.h"
#include "TSL2561.h"
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------


//#define THERMOMETER DS18S20
#define THERMOMETER DS18B20

Serial serie(SERIAL_TX, SERIAL_RX);
TSL2561 LUM(PB_7, PB_6); // Luminosité (I2C:SDA,SCL)
AnalogIn Humidite(PA_0);
Serial PC(PA_2, PA_3);
DigitalOut myled(LED1);
Serial sigfox(PA_9, PA_10);
int i, Hum, Temp_sol, Lum;

/*int count(int i){
    //pc.printf("This program runs since %d secondes.\r\n", i);
        sigfox.printf("AT$SS=%02x\r\n",i);
    return i;
    }*/

int main()
{   
    //int  i = 1;
    serie.printf("Hello World !\n");
     // device( crcOn, useAddress, parasitic, mbed pin )
    THERMOMETER device(true, true, false, D3);
    
   while (!device.initialize());    // keep calling until it works
    
    while (true)
    {   
     //int i=10;
    
        wait(10);
        //serie.printf("This program runs since %d seconds.\n", i++);
        myled = !myled;
        device.readTemperature(); 
        Hum = (int)Humidite.read();
        Temp_sol = (int)device.readTemperature();
        Lum = (int) LUM.lux();
        serie.printf("Lum: %f \r\n", LUM.lux());
        serie.printf("Hum: %f \n\r",Humidite.read());
        serie.printf("Humidite: %d \n\r", Hum);
        serie.printf("Temp_sol: %d \n\r",Temp_sol);
        sigfox.printf("AT$SS=%02x %02x %02x \r\n"Temp_sol, Lum, Hum );
    }
    return EXIT_SUCCESS;
}
