#include "mbed.h"
#include "PinDetect.h"
DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);
DigitalOut l4(LED4);
PinDetect  pb(p8);
// SPST Pushbutton demo using internal PullUp function
// no external PullUp resistor needed
// Pushbutton from P8 to GND.

// Global count variable
int volatile count=0;
//int volatile hit = 1;

void light_left_2_right(int mode){  
    for(int i=0;i<4 ;i++) {
        l4 = 1 >> i;
        l3 = 2 >> i;
        l2 = 4 >> i;
        l1 = 8 >> i;
        if(mode) //fast
            wait(0.1);
        else //slow
            wait(0.3);
    }        
}

void light_right_2_left(int mode){
    for(int i=0;i<4 ;i++) {
        l1 = 1 >> i;
        l2 = 2 >> i;
        l3 = 4 >> i;
        l4 = 8 >> i;
        if(mode) //fast
            wait(0.1);
        else //slow
            wait(0.3);
    }
}

void blink_me(void) {
    int mode;
    mode = count %4;
    if(mode == 0) light_left_2_right(0);
    if(mode == 1) light_right_2_left(0);
    if(mode == 2) light_left_2_right(1);
    if(mode == 3) light_right_2_left(1;
}

//Interrupt Sub-routine
void p8_release_callback(void) {
    l4=0;
    l3=0;
    l2=0;
    l1=0;
}

void p8_hit_callback(void) {
   count++;
   wait(0.01);
}

int main() {
    pb.mode(PullUp);
    wait(0.01);
    // Setup Interrupt callback functions for a pb hit
    pb.attach_deasserted(&p8_hit_callback);
    pb.attach_asserted(&p8_release_callback);
    // Start sampling pb inputs using interrupts
    pb.setSampleFrequency();
    while(1) {
        blink_me(); 
    }
}