// Simple program to read the distance from an SRF05 using the SRF05 library

#include "mbed.h"
#include "SRF05.h"

SRF05 srf(p9, p10);
 
int main() { 
    float curval;
    float percentage;
    float tankfull = 10;
    float tankempty = 60;
    float warning = 10; //percentage
    float range = tankempty-tankfull; // 100-(value-5)/range*100
     while(1) { 
         curval = srf.read();
         percentage = 100-(((curval-tankfull)/range)*100);
         printf ("Percentage Remaining: %.0f (%.0f)\n\r", percentage, curval);
         if (percentage < warning){
             printf ("WARNING: Water Level Below 10% \n\r");
             }             
         wait(1); 
     } 
 } 