#include <io_pins.h>
#include <display.h>
#include <mbed.h>
#include <stdlib.h>

SPI display_ctr_display(MOSI, MISO, SCLK);
DigitalOut dsp_ncs_display(LOAD);
Serial pc_display(USBTX, USBRX);




void format_data(){
    dsp_ncs_display = 1;
    display_ctr_display.format(16); // 16 bits per frame, mode 0
    dsp_ncs_display = 0;
}

void send_data(int dat){
    dsp_ncs_display = 0;
    display_ctr_display.write(dat); //configures the decode register
    dsp_ncs_display = 1;
}

void bin2bcd_array_mod(int *bcdArr, int num){
        for(int i = 0; i < 4; i++){
            bcdArr[i] = 0;
        }
        int i = 0;
        while(num>0){
            bcdArr[i] = num%10;
            num = num/10;
            i = i+1;        
}
}



void bin2bcd_array_sprintf(int *bcdArr, int num){
    for(int i = 0; i < 4; i++){
            bcdArr[i] = 0;
        }
    char buffer[5];
    sprintf(buffer, "%d", num);
    for(int i = 0; i < 4; i++){
        bcdArr[3-i] = buffer[i]-0x30;   
    }


}
