#include <io_pins.h>
#include <stepper.h>
#include <mbed.h>
#include <stdlib.h>
#include <spi_fix.h>


Serial pc2(USBTX, USBRX);

spi_cfg DRV8806 = {    
    DRV8806_ID, //ID should be unique for each slave type    
    STP_DRV8806_NCS, //The pin driving the slave's chip select    
    DRV8806_MODE, //mode
    DRV8806_FREQ, //frequency
    DRV8806_BITS //num of bits
    
};
static int stepper_pos[4] = {0x03, 0x06, 0x0c, 0x09};
static int stp_index = 0;

void stp_init(){
    spi_send(DRV8806, stepper_pos[stp_index]);
    
}
void stp_step(int direction){
    if (direction == STP_CW){
        if (stp_index<3){
            stp_index+=1;
        }
        else
            stp_index = 0; 
    }
    else if(direction == STP_CCW){
        if (stp_index>0){
            stp_index = stp_index-1;
            
        }
        else{
            stp_index = 3;
        }
    
    
        
            
    }
    pc2.printf("%d \n", stepper_pos[stp_index]);
    spi_send(DRV8806, stepper_pos[stp_index]);
    
}

