#ifndef SPI_FIX
#define SPI_FIX

#include <mbed.h>

#define SPI_NO_ID 1
#define SPI_AS1107_ID 2
#define DRV8806_ID 3


struct spi_cfg {    
    int spi_id; //ID should be unique for each slave type    
    DigitalOut spi_ncs; //The pin driving the slave's chip select    
    int spi_mode; //SPI mode needed by this slave    
    int spi_freq; //SPI frequency needed by this slave    
    int spi_no_bits; //No. of data bits to be transfered each send to the slave};
};


void spi_send(struct spi_cfg spi_config, int spi_data);

#endif
