/**********************************************************
* EECS 397
*
* Assignment Name: Lab 1: Two_speed_blinky
*
* Author(s): Markowitz, Billy;
*
* Purpose: turn the User LED on for .5 seconds, off for 1 second, on for .5 seconds,
* off for 2 seconds, and then repeat sequence ad infinitum.
*
* Last Modified 2018-01-24
*
**********************************************************/

#include <mbed.h>
#include <io_pins.h>
#include <display.h>
#include <spi_fix.h>
#include <stepper.h>

Serial pc(USBTX, USBRX);
DigitalIn jogL(UI_JOG_LEFT_BUTTON);
DigitalIn jogR(UI_JOG_RIGHT_BUTTON);



extern spi_cfg AS1107;

int main(void)
{
  jogL.mode(PullUp);
jogR.mode(PullUp);  

    
    int data;
    int digit_array[4];
    display_init();
    // main loop
    pc.printf("Please enter a 1 for display test, 2 for stepper test");
    pc.scanf("%d", &data);
    if(data == 1){
        pc.printf("Please Enter a Digit from 0-9999 \n");
        while(1) {
            
    
            if(pc.readable()) {
                pc.scanf("%d", &data);
                if(data<=9999 && data>=0) {
                    pc.printf("%d",data);
                    bin2bcd_array_mod(digit_array, data);
                    for(int i=0; i<4; i++){
                        spi_send(AS1107, DISPLAY_1*(i+1)+digit_array[i]);    
                    }    
                        
                pc.printf("Please Enter a Digit from 0-9999 \n");     
                }
    
                else
                    pc.printf("Please print a valid number \n");
    
            }
    
        }
    }
    if(data == 2){
        stp_init();
        while(1){
            wait(.1);
            if(jogL.read() == 0){
                stp_step(STP_CW);
            }   
            else if(jogR.read() == 0){
                stp_step(STP_CCW);       
            }
        }
    }
}


