#include <io_pins.h>
#include <display.h>
#include <mbed.h>
#include <stdlib.h>
#include <spi_fix.h>



Serial pc_display(USBTX, USBRX);
DigitalOut dsp_ncs_display(DSP_AS1107_NCS);
spi_cfg AS1107 = {    SPI_AS1107_ID,    DSP_AS1107_NCS,    AS1107_MODE,    AS1107_FREQ,    AS1107_BITS};

void bin2bcd_array_mod(int *bcdArr, int num){
        for(int i = 0; i < 4; i++){
            bcdArr[i] = 0;
        }
        int i = 0;
        while(num>0){
            bcdArr[3-i] = num%10;
            num = num/10;
            i = i+1;        
        }
}

void display_init(){
    // Configuring the Controller
    spi_send(AS1107, 0x0f01);
    wait(1.5);
    spi_send(AS1107, 0x0F00);
    spi_send(AS1107, 0x0A0F);
    spi_send(AS1107, 0x0B04);
    spi_send(AS1107, 0x0C01); //set to normal shutdown mode
    spi_send(AS1107, 0x090F); //configures the decode register
    spi_send(AS1107, DISPLAY_1); //Digit 1 is 0
    spi_send(AS1107, DISPLAY_2);
    spi_send(AS1107, DISPLAY_3);
    spi_send(AS1107, DISPLAY_4);
    spi_send(AS1107, LED_DISPLAY);
}

void bin2bcd_array_sprintf(int *bcdArr, int num){
    for(int i = 0; i < 4; i++){
            bcdArr[i] = 0;
        }
    char buffer[5];
    sprintf(buffer, "%d", num);
    
        if (num<10){
                bcdArr[3] = buffer[0];
                
        }
        else if(num <100){
            bcdArr[2] = buffer[0];
            bcdArr[3] = buffer[1];
            
        }
        else if(num < 1000){
            bcdArr[1] = buffer[0];
            bcdArr[2] = buffer[1];
            bcdArr[3] = buffer[2];
            
            
        }
        else{
        for(int i = 0; i < 4; i++){
            bcdArr[i] = buffer[i]-0x30;
        }
    }


}
