#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"

#define VOLUME 1
// Parameters
int port_number = 123;

// Networking
EthernetInterface eth;
NTPClient ntpClient;

//Pins
PwmOut pwm_pin(p21);
DigitalIn button(p12);
BusOut LEDS(LED1,LED2,LED3,LED4);
uLCD_4DGL uLCD(p9,p10,p11);

// Plays a sound with the defined frequency, duration, and volume
void playNote(float frequency, float duration, float volume) {
    pwm_pin.period(1.0/frequency);
    pwm_pin = volume/2.0;
    wait(duration);
    pwm_pin = 0.0;
}

void soundalarm()
{
    time_t ctTime; 
    eth.init();
    eth.connect();
    
    char* domainName="0.uk.pool.ntp.org";
    //Initilaise LCD
    uLCD.baudrate(115200);

    // Read time from server
    ntpClient.setTime(domainName,123,0x00005000);
    //Buffers for holding time when the alarm begins and ends
    char buffer1[80];
    char buffer2[80];
    wait(2);
    eth.disconnect();
    ctTime = time(NULL); 
    strftime(buffer1, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                                                localtime(&ctTime));
    // Loop
    while((button==1))
     {   
    playNote(960,1.2,VOLUME);
    LEDS=0x0F;
    wait(0.1);
    playNote(770,1.2,VOLUME);
    LEDS=0;
    }
    uLCD.locate(0,12);
    uLCD.printf("Alarm Began On:\n");
    uLCD.printf("    UTC/GMT:\n%s", buffer1); 
    ctTime = time(NULL); 
    strftime(buffer2, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                                                localtime(&ctTime));
    uLCD.printf("Alarm Stopped On:\n");
    uLCD.printf("    UTC/GMT:\n%s", buffer2);
    wait(30);
    uLCD.cls();                                   
}






