#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
PwmOut Clock(PTD4);
PwmOut Output(////);
AnalogIn Sensor(////);

float adjustmentFactor = 1.0; //change so that sensor data is calibrated
float ref = 3.0;
float error = 0.0;
float totalError = 0.0;
int period = 1000;
int PW = period/2;

int outPeriod = period; //assume period always is the same
int outPW = outPeriod/2;

float Ki = 0; //adjust
float Kp = 30; //adjust

Ticker Controller;
int flag = 0;

void Control(){
     error = ref - Sensor.read()*adjustmentFactor;
     totalError += error;
     outPW = Kp*error + Ki*totalError;
     Output.period_us(outPeriod);
     Output.pulsewidth_us(int(outPW));
     flag = 1;
 }
 
int main() {
    Clock.period_us(period);
    Clock.pulsewidth_us(PW);
    Controller.attach_us(Control,period*128); //assumed that we should wait 128 clock cycles before activating controller
                                              //because line camera requires 128 cycles. should verify

    while(1) {
        if (flag) {
             pc.printf("PW: %d \n\r",outPW);
             flag = 0;
        }
    }

}
