// Goal: Program that receives and send 4 channels of data.
// Receives: 1kHz
// Sends: 70kbits/s

//DONE:
  //  O programa lê e envia dados da taxa indicada por TIMER_RATE
//TODO:
   // Comunicação com bluetooth
   // Ver porque o tempo de envio está tão alto.

#include "mbed.h"

/*--------------Signal Definition-----------------*/
//16bits buffer
#define ECG1 0
#define ECG2 1
#define RESP 2
#define PPG 3

//8bits buffer
#define LSB_ECG1 0
#define MSB_ECG1 1
#define LSB_ECG2 2
#define MSB_ECG2 3
#define LSB_RESP 4
#define MSB_RESP 5
#define LSB_PPG 6
#define MSB_PPG 7


/*---------------- Sample Speed Timer --------------*/
#define TIMER_RATE 0.01

/*-----READS THE ANALOG SIGNAL FROM THE SENSORS-----*/

AnalogIn Ecg1(A0);
AnalogIn Ecg2(A1);
AnalogIn Resp(A3);
AnalogIn Ppg(A4);

DigitalOut testSpeed(PTE1);


/*------CONTROLS THE DATA RATE OF THE READING------*/
Ticker t0;
Serial pc(USBTX,USBRX);


/*---HANDLES THE TIMER AND SERIAL INTERRUPTIONS-----*/

void t0_handler(void);
void rx_Handler(void);

char test = 0;  // Tests the data received from the computer in order to start the reading 


/*------------BUFFER TO STORE DATA------------------*/

uint16_t buffer_16[4] = {0,0,0,0};
char buffer_8[8] = {0,0,0,0,0,0,0,0};


int main() {
    pc.printf("main");
    pc.attach(&rx_Handler, pc.RxIrq);
    
    
    while(1){}       

        //aciona porta
        
        //pc.printf("%i,%i,%i,%i\n",buffer[ECG1],buffer[ECG2],buffer[RESP],buffer[PPG]);//PUTC
       
 
}

/*----------------------FUNCTIONS-----------------------*/

    //Reads and send data to the computer 

void t0_handler(void){

//Reads the Analog Ports
        buffer_16[ECG1] = Ecg1.read_u16();
        buffer_16[ECG2] = Ecg2.read_u16();
        buffer_16[RESP] = Resp.read_u16();
        buffer_16[PPG] = Ppg.read_u16();

//Divides de buffer 16 into multiple buffers;
//Falta rotacionar:
//Ver Ser a rotação está correta

        buffer_8[LSB_ECG1] = (char)(buffer_16[ECG1]);
        buffer_8[MSB_ECG1] = (char)((buffer_16[ECG1]&0xFF)>>8);
        
        buffer_8[LSB_ECG2] = (char)(buffer_16[ECG2]);
        buffer_8[LSB_ECG2] = (char)((buffer_16[ECG2]&0xFF)>>8);
        
        buffer_8[LSB_RESP] = (char)(buffer_16[RESP]);
        buffer_8[MSB_RESP] = (char)((buffer_16[RESP]&0xFF)>>8);
        
        buffer_8[LSB_PPG] = (char)(buffer_16[PPG]);
        buffer_8[MSB_PPG] = (char)((buffer_16[PPG]&0xFF)>>8);
    
//Sends to the computer
        testSpeed = 1;
        
        pc.putc(buffer_8[LSB_ECG1]);       //texto se foi bem sucedida
        pc.putc(buffer_8[MSB_ECG1]);
        pc.putc(buffer_8[LSB_ECG2]);
        pc.putc(buffer_8[MSB_ECG2]);
        pc.putc(buffer_8[LSB_RESP]);
        pc.putc(buffer_8[MSB_RESP]);
        pc.putc(buffer_8[LSB_PPG]);
        pc.putc(buffer_8[MSB_PPG]);
        
       
        testSpeed = 0;
  
    
    }

    //This function must 

void rx_Handler(void){
    // A programação não estava funcionando poisnão se deve utilizar interrupções para realizar grandes tarefas;
    // Elas travam e não funciona mais nada.
    // Como fazer para não ficar testando no main?? Sexta feira no globo reporter
    
    test = pc.getc();    // it gets the received character
    pc.putc(test);//debug

//--Tests the Receive Character----

    if(test == '2'|| test == '2')
        {           
    t0.attach(&t0_handler,TIMER_RATE);
        
    }else if (test=='3'|| test == '3')
        {
    t0.detach();
        }   

  
}
