/*
    Jared Walker
    Ridwan Sadiq
    Emanuel Abdul-Salaam
    Juan Padilla
*/
#include <time.h>       /* time_t, struct tm, difftime, time, mktime */
#include <ctime>
#include "mbed.h"
#include "uLCD_4DGL.h"
//#include "SDFileSystem.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "PinDetect.h"
#include "MMA8452.h"
#include "Speaker.h"

MMA8452 acc(p28, p27, 40000); //instantiate an acc object
BusOut myled(LED1,LED2,LED3,LED4);
Serial blue(p9,p10);
Serial pc(USBTX, USBRX);
uLCD_4DGL ulcd(p13,p14,p11);
DigitalIn pb2(p24);//check later if thats ok
DigitalIn pb1(p25);//check later if thats ok
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut speaker(p26); 
wave_player waver(&speaker);

int screenBreak = 0;
int but_pushed1 = 0; // ==1 -> pb1 pushed, == 2 -> pb2 pushed
int but_pushed2 = 0;
bool selectedDiceArray[5];
int faceValCarry[5];
int randoArray[5]; 
int accFlag = 0; // this is gonna be the variable that the accelerometer flips to roll the dice


int selectDice()
{
    char bnum=0;
    char bhit=0;
    int diceNum = 0;
    
    if (blue.getc()=='!') {
        if (blue.getc()=='B') { //button data packet
            bnum = blue.getc(); //button number
            bhit = blue.getc(); //1=hit, 0=release
            if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                if ((bnum>='1')&&(bnum<='5')){ //is a number button 1..4
                    diceNum = bnum-48;
                    selectedDiceArray[diceNum]= 1;
                    if (bhit=='1') {
                        myled = bnum - '0';
                    } else {
                        myled = '0';
                    }
                }
            }
        }
    }
    return diceNum;
}


void draw_start(){
    ulcd.text_width(2); 
    ulcd.text_height(2);
    ulcd.locate(2,2);
    ulcd.printf("\n YAHTZEE");
    
    ulcd.text_width(1); 
    ulcd.text_height(1);
    ulcd.locate(4,8);
    ulcd.printf("\n   Press to Roll");

    // Processing
    
    
}

void shaking_sound() {
    FILE *wave_file;
    //open wav file and play it
    wave_file=fopen("/sd/thread_sound.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    //end of program
    wait(.2);
}

void draw_readyRoll(){
    ulcd.text_width(1); 
    ulcd.text_height(1);
    ulcd.locate(4,1);
    ulcd.printf("\n   Ready to Roll");
    
    ulcd.text_width(2); 
    ulcd.text_height(2);
    ulcd.locate(2,1);
    ulcd.printf("\n  Press\n  Roll\n Button\n to Roll");

    // Processing
    
    
}


void draw_diceDisp(){
    ulcd.text_width(1); 
    ulcd.text_height(1);
    ulcd.locate(1,1);
    ulcd.printf("Do you want to select any dice?");

    // Processing
    
    
}

int roll(){

    int rando = (rand()%6)+1; 
    
    return rando;
}

void draw_diceSelect(){
    ulcd.text_width(1); 
    ulcd.text_height(1);
    ulcd.locate(1,1);
    ulcd.printf("Press button 1 to roll again");
    ulcd.printf("\n Press button 2 to break");
    
    // Processing
    
    
}


void draw_scoreScreen(){
    // I think we should add "ulcd.cls;" to declutter the screen sometimes, or print a black background
    ulcd.text_width(1); 
    ulcd.text_height(1);
    ulcd.locate(1,1);
    ulcd.printf("Please score your round and reset.");
    
    // Processing
    
    
}

// This fuctuion prints a single dice to the screen, but can be used over and over to print every dice
    int xarry[] = {22,22,64,64,105};//holds the center point for every dice on the X axis (for ulcd)
    int yarry[] = {32,96,32,96,32};//holds the center point for every dice on the Y axis (for ulcd)
void diceLoc(int diceLoc,int diceFaceNum,int color)//diceLoc is the location of the dice (1-5) and diceFaceNum is the number on the dice face (provided by a random number gen
{ 
        
            int x1=xarry[diceLoc] + 20;
            int x2=xarry[diceLoc] - 20;
            int y1=yarry[diceLoc] + 20;
            int y2=yarry[diceLoc] - 20;
            if(color == 1){
                ulcd.rectangle(x1,y1,x2,y2,WHITE);
            }
            else if(color == 2){
                ulcd.rectangle(x1,y1,x2,y2,BLUE);
            }
        switch(diceFaceNum){
            case 1://if dice =1
                ulcd.filled_circle(xarry[diceLoc] , yarry[diceLoc] ,3, WHITE);
            break;
            
            case 2://if dice =2
         
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]- 10), 3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]+10) ,3, WHITE);

            break;
            
            case 3://so on
                ulcd.filled_circle((xarry[diceLoc]) , (yarry[diceLoc]) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]+10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc] - 10) ,3, WHITE);

            break;  
                      
            case 4://so forth 
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]- 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]+10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]+ 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]- 10) ,3, WHITE);

            break; 
                       
            case 5:
              
                ulcd.filled_circle((xarry[diceLoc]) , (yarry[diceLoc]) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]+ 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]+10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]- 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]- 10) ,3, WHITE);
            break;                
            case 6:
       
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]- 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]+10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]+ 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10) , (yarry[diceLoc]- 10) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]+ 10) , (yarry[diceLoc]) ,3, WHITE);
                ulcd.filled_circle((xarry[diceLoc]- 10 ) , (yarry[diceLoc]) ,3, WHITE);
                break;  
            
            default:
                break;
            }
}
//end dice printing function 


void shakeDetect()
{   
        acc.setBitDepth(MMA8452::BIT_DEPTH_12);
        acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
        acc.setDataRate(MMA8452::RATE_100);// dont worry about this garbage. it just sets some internal values for the acc                  
        double x = 0;
        double y = 0;
        
        while(1)
        {      
            acc.readXGravity(&x); //notice this is passed by reference use pointers
            acc.readYGravity(&y);
            if(x >= .6 || y >= .6)
            {
                accFlag = 1;
                break;
            }        
        }
        
}// end acc stuff

int main()
{

    ulcd.cls();
    ulcd.baudrate(3000000); //jack up baud rate to max for fast display
    //int selectedDice = 0;
    
    while(1)
    {
        draw_start(); 
        //audio needed here
        
        screenBreak = pb1;
        if(screenBreak == 1)
        {
            break;
        }
    }
    
    screenBreak = 0;
    
    for (int j=0; 3 ;++j)
    { //tbis is where the Game happens, breaks after j = 3 for three rounds   
        while(1)
        {
            draw_readyRoll();
            screenBreak = pb1;   
            shakeDetect();
            if (accFlag== 1 && screenBreak == 1)
            {
                break;
            }
            
        }
        accFlag = 0;
        screenBreak = 0;
        for(int k = 0; 5 ; ++k)
        {
            if(selectedDiceArray[k] == false)
            {
            randoArray[k] = roll();
            }
        }
     
        for (int i=0; 5 ;++i)
        { //tbis part prints the dice on the ulcd 

            if(selectedDiceArray[i] == false)
            {//this wont reprint the values of the duce if the dice has been selected on the bluetooth   
                diceLoc(i,randoArray[i],1);// print function for dice. i is the location of the dice and rando is a random number for the dice face
            }
            else if (selectedDiceArray[i] == true)
            {
                diceLoc(i,randoArray[i],2);
                //faceValCarry[i] = randoArray[i];// I think this works, what I am tring to do is retain the random value I generated earlier
            }
        }
        
        draw_diceDisp();
        wait(2);
        
        while(1)
        {
            draw_diceSelect();
            but_pushed1 = pb1;
            but_pushed2 = pb2;
            if(but_pushed1==1)
            {
                    selectDice();
                    break;
            }
            
            else if(but_pushed2==1)
            {    
                    break;
            }
        }  
    }
        
        while (1)
        {//score screen
            draw_scoreScreen();
        }
            

}//end main()

    
        //selectedDice = selectDice();
        //pc.printf("Selected Dice: '%d  %d'\n", selectedDice, selectedDiceArray[selectedDice]);
        
        /* pseudocode to match flow block diagram
        but_pushed = -1;
        while(but_pushed != 2){ // enter while if 1 pressed (yes) -> (initially -1)
            but_pushed = -1; 
            while (but_pushed != 1){ 
                draw_readyRoll();
                draw_diceDisp();
            }
            draw_diceSelect();
        }
        */
//        draw_scoreScreen();

