#include "mbed.h"
#include <stdio.h>      /* printf */
#include <time.h>       /* time_t, struct tm, difftime, time, mktime */
#include <ctime>
#include "farkel_class.h"
#include "die.h"
#include "Speaker.h"

    Speaker mySpeaker(p24);

void playJingle()
{
    float g5=783.99; 
    float f5=698.46; 
    float e5=659.25; 
    float d5=587.33; 
    float g4=392;
    mySpeaker.PlayNote(g5,.32,.1);
    mySpeaker.PlayNote(f5,.32/2,.1);
    mySpeaker.PlayNote(e5,.32/2,.1);
    mySpeaker.PlayNote(d5,.32/2,.1);
    mySpeaker.PlayNote(g4,.32,.1);

}

    Serial pc(USBTX,USBRX); //not used in this program
    MMA8452 acc(p28, p27, 40000); //instantiate an acc object!

    int shakeDetect(int flag){   
        acc.setBitDepth(MMA8452::BIT_DEPTH_12);
        acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
        acc.setDataRate(MMA8452::RATE_100);
                           
        double x = 0;
        while(1){      
            acc.readXGravity(&x); //notice this is passed by reference use pointers
       
            if(x >= .6){
                flag = 0;
                break;
                }
        }
    return flag;
}

 

int main() {
    
    srand(time(0));
    farkel player1(0);
    Dice utility(0);
    int flag2Play = 0;  
    int diceNum = 6;
    int mainMenuFlag = 0;
    int gameScore = 0;
    int scorehold = 0;
    double grav = 0;
    
    while(1) {   
        while(mainMenuFlag == 0 || mainMenuFlag ==1){  
            flag2Play = 0;
            if (mainMenuFlag == 1){
                diceNum = 6;
                gameScore = 0;
                mainMenuFlag = 0;
                scorehold = 0;
            }

            if(mainMenuFlag == 0){
                player1.mainMenu(diceNum);
            }
            
            acc.readXGravity(&grav);
            
            if(grav >.6){
                mainMenuFlag = 2;
                playJingle();

            }
        diceNum = player1.diceNumInc(diceNum);
        //mainMenuFlag = shakeDetect(mainMenuFlag);
        if(mainMenuFlag == 2){
            player1.clearSc();
        }
        }
        //uLCD.printf("Entered Loop"); wait(1);
        if(flag2Play == 0){
            for (int i=0;i<diceNum;++i){
                int rando = player1.roll();
                player1.dicePlacer(i,rando,gameScore);
                }

            scorehold = player1.gameScoring();
            
            if(scorehold == 0){
                gameScore = 0;
                player1.printfark();
            }
            gameScore += scorehold;
            
            flag2Play++;
        }f
        
        if(flag2Play == 1 || scorehold == 0 ){
            mainMenuFlag = player1.butDetect(gameScore);
            player1.clearSc();
            }
        diceNum = player1.resetDie(diceNum,scorehold);
        
        //mainMenuFlag = player1.back2MainMenu();

//uLCD.printf("Finished a loop"); wait(1);
    
    }
}
