#include "mbed.h"
#include "DHT.h"
#include "TextLCD.h"

#define BUFFER_SIZE 3
#define ON "on"
#define OFF "of"
#define LOW "lo"
#define MEDIUM "me"
#define HIGH "hi"

TextLCD lcd(PTC2,PTA2,PTB23,PTA1,PTB9,PTC17);
UARTSerial bluetooth(PTC15, PTC14, 38400);
Serial pc(USBTX, USBRX);
DHT temperature(D0, DHT11);
PwmOut motor(PTC3); // PWM pin
DigitalOut ON_led(D15);
DigitalOut OFF_led(D14);

int dutycycle = 15;
int desired_temp = 76;

int main(){
    
    //switch ON green LED and off red LED
    OFF_led = 1;
    ON_led = 0;
    
    //character array to receive BT commands
    char command[BUFFER_SIZE];

    //initialize temperature variable
    float temp = 0.0f;
    
    //temperature sensor error indicator
    int sensor_input_error = 0 ;
    
    //system status flag: ON or OFF
    int on_flag = 0;
    
    //set the PWM period for the motor
    motor.period(0.01);
    
    //make bt reading non blocking
    bluetooth.set_blocking(false);
    
    while(true){       
            
            //Read the temperature sensor data
            sensor_input_error = temperature.readData();
        
            //if no error, read temperature in Farenheit
            if(sensor_input_error == 0){
                temp = temperature.ReadTemperature(FARENHEIT);
            }
            
            //print to serial the currently measured temperature
            pc.printf("temperature is %2d F\n",int(temp));
            
            //print the temperature on the LCD
            lcd.cls();
            lcd.printf("Temperature is:");
            lcd.locate(6,1);
            lcd.printf("%2.0f F", temp);
        
            //compare the ambient temperature to the desired temperature
            //when flag is on
            if(on_flag == 1 ){
                ON_led = 1;
                OFF_led = 0;
                if(temp > desired_temp){
                    motor = (float)dutycycle/100.0;
                }else{
                    motor = 0;
                }
            //when flag is off
            }else{
                motor = 0;
                ON_led = 0;
                OFF_led = 1;
            }
            wait(1);
        
            //Poll command from bluetooth
            bluetooth.read(command, BUFFER_SIZE);
            
            //compare incoming data with NULL
            //then parse each one as a specific command
            if(strncmp(command,"\0",3) != 0){
                if(strncmp(command,ON,3) == 0){
                    on_flag = 1;
                }else if(strncmp(command,OFF,3) == 0){
                    on_flag = 0;
                  }else if(strncmp(command,LOW,3) == 0){
                    dutycycle = 12;
                    }else if(strncmp(command,MEDIUM,3) == 0){
                        dutycycle = 15;
                     }else if(strncmp(command,HIGH,3) == 0){
                        dutycycle = 20;
                    }else {
                        sscanf(command, "%d", &desired_temp);
                    }
            }//end of command null compare
            
          //reset the command back to NULL
            strcpy(command, "\0");
    }
}