/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: DE0_driver.cpp
// file content description:
//      * function to initialize the hardware interface for communication
//        between the FPGA and LPC1768
//      * function to read required data from the DE0 (FPGA).
/******************************************************************************/

#include "mbed.h"
#include "DE0_driver.h"

#define DUMMY   0

SPI DE0(p5, p6, p7); // Configure pins and name SPI port.

void ResetDE0(void);
void RestartSpi(void);

DigitalOut IoReset(p15);    // 0-1-0 reset for all SPI peripherals in the DE0 FPGA
DigitalOut SpiReset(p14);   // 0-1-0 tells the DE0 SPI interace that the next word sent is a control word

int SignExtend(int16_t x)
{
    // if number is negative
    if(x&0x00008000) {
        // reserve the sign bit into the 32-bit number
        x = x|0xFFFF0000;
    }
    return x;
}


// To reset all SPI peripheral on the FPGA:
void ResetDE0(void){
    IoReset=0; // Reset all DE0 peripherals
    IoReset=1;
    wait_us(5);
    IoReset=0; 
    }
   
// To reset the SPI channel in the slave and restart with a new SPI protocol.    
void RestartSpi(void) {
    // Restart DE0 SPI channel so the next word sent is interpreted as the Control Word
    SpiReset=0;
    SpiReset=1;
    wait_us(5);
    SpiReset=0;
    }


/*******************************************************************************
* @brief    This is the initialization function for the DE0 FPGA - communication
            between the FPGA and MCU is done through SPI. The function 
            initializes the SPI channel to a bit rate of 500kbps
* @param    none
* @return   none
*******************************************************************************/
void DE0_init(void)
{
 DE0.format(16,1); // Define SPI format: 16-bit words, mode 1 protocol.
 DE0.frequency(500000); // Set SPI bit rate (Hz). Default is 1 MHz
 ResetDE0();
}

/*******************************************************************************
Before an SPI data transaction with the DE0 FPGA can occur, a control word must 
first be written to the slave that specifies: 

i) the number of word transfers,
ii) the offset or starting address within the slave, and 
iii) whether the transaction consists of ‘simultaneous read write’ or whether the 
transactions are ‘read only’ (from the slave). 

A control word need only be written once – if the same transactions are repeated.
Subsequent transactions use the protocol specified by the last control word that
was written. To change the transaction protocol a new control needs to be
written. To write a new control word, the SpiReset input must first be set then
cleared followed by a SPI write of a 16-bit word that is interpreted as the
control word by the slave.
 
The 16-bit control word format appears below.

1        7bits            8bits
rd | address offset | number of words 

When RD = 1, no write operation occurs within the slave. Data on the MOSI is 
ignored by the slave. When RD = 0, a simultaneous read + write of the slave 
occurs.
*******************************************************************************/


/*******************************************************************************
* @brief    This function reads the output from the FPGA through the SPI channel
* @param    none
* @return   none
*******************************************************************************/
void DE0_read(sensors_t * sensors)
{
    // To place SPI module into control mode, where the next word received by the
    // slave is interpreted as a control word.
    RestartSpi();
    
    // rd = 1 (control if 1) address = 0 no of word = 2 - Specify a read only transactions of 2 words
    sensors->id = (uint16_t)DE0.write(0x8004);
    
    // Read the two 16 bits registers from the FPGA 
    sensors->dp_right = SignExtend(DE0.write(DUMMY)); // A SPI read only transaction occurs.
    sensors->dt_right = DE0.write(DUMMY); //
    
    sensors->dp_left = SignExtend(DE0.write(DUMMY)); // A SPI read only transaction occurs.
    sensors->dt_left = DE0.write(DUMMY); //
    
}
    