/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: ui.cpp
// file content description:
//      * Functions to display and manage the user interface on the PC terminal. 
/******************************************************************************/

#include "mbed.h"
#include "WatchdogThread.h"
#include "ui.h"
#include "CameraThread.h"
#include "PiControlThread.h"

Serial bluetooth(p9,p10); // Define the bluetooth channel and IO pins
Serial pc(USBTX, USBRX); // Pins (tx, rx) for PC serial channel

bool killRobot = false;

// variable to store character recieved from terminal
char x;


void displayStartupMsg()
{
    bluetooth.printf("\r\n************************************");
    bluetooth.printf("\r\n**** AUTONOMOUS FOLLOWING ROBOT ****");
    bluetooth.printf("\r\n************************************");
    bluetooth.printf("\r\n-PRESS 'r' TO KILL ROBOT");
}

/******************************************************************************
                           User interface 3 - Manual Control
******************************************************************************/

void consoleUI(void)
{
    if (bluetooth.readable()) {
        x = bluetooth.getc();
        
        // if input from console is the letter 'r'
        if(x == 'r') {
            // reset watchdog timer
            WatchdogReset();
            setpointR = 0;
            setpointL = 0;
            bluetooth.printf("\r\nWatchdog has been reset");
        }
        
/******************************ROBOT FWD RVS***********************************/
        // if w is pressed increase the speed
        // by incrementing u
        else if(x == 'w') {
            mutexSetpoint.lock();
            Setpoint = -40;
            mutexSetpoint.unlock();
        
        }

        // if s is pressed decrease the speed
        // by decrementing u
        else if(x == 's') {
            mutexSetpoint.lock();
            Setpoint = 40;
            mutexSetpoint.unlock();
        
        }

/******************************ROBOT STEERING**********************************/        
        else if (x=='a')
        {
            mutexSetpoint.lock();
            SteeringError = 80;
            mutexSetpoint.unlock();
        }
        else if (x=='d')
        {
            mutexSetpoint.lock();
            SteeringError = -80;
            mutexSetpoint.unlock();
        }        
        // error wrong input
        else {
            bluetooth.printf("\r\nwrong input please enter \'w\' to increase the speed, \'s\' to reduce it or move in the opposite direction and \'r\' to reset the watchdog");
        }
    }
    else{
        // If no key is pressed stop the robot. 
        Setpoint = 0;
        SteeringError = 0;
    }
    
}
