/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: WatchdogThread.cpp
// file content description: 
//      * Function to create the Watchdog Thead
//      * Watchdog thread
//      * Watchdog ISR 
//      * Variables related to the functionality of the thread
/******************************************************************************/

#include "mbed.h"

osThreadId WatchdogId;
osTimerId oneShot;


// Function prototypes
void WatchdogISR(void const *n);
void WatchdogThread(void const *argument);

// Declare WatchdogThread as a thread/process
osTimerDef(Wdtimer, WatchdogISR); 

/******************************************************************************/
//  osPriorityIdle          = -3,          ///< priority: idle (lowest)
//  osPriorityLow           = -2,          ///< priority: low
//  osPriorityBelowNormal   = -1,          ///< priority: below normal
//  osPriorityNormal        =  0,          ///< priority: normal (default)
//  osPriorityAboveNormal   = +1,          ///< priority: above normal
//  osPriorityHigh          = +2,          ///< priority: high
//  osPriorityRealtime      = +3,          ///< priority: realtime (highest)
/******************************************************************************/

// Declare WatchdogThread as a thread/process
osThreadDef(WatchdogThread, osPriorityRealtime, 1024); 

DigitalOut led1(LED1);


bool WatchdogThreadInit()
{
    bool retval;
    
    WatchdogId = osThreadCreate(osThread(WatchdogThread), NULL);
    
    if(WatchdogId)
    {
        // Start the watch dog timer and enable the watch dog interrupt
        oneShot = osTimerCreate(osTimer(Wdtimer), osTimerOnce, (void *)0);
        retval = true;
    }
    else
    {
        retval = false;
    }
    
    return retval;
    
}


/*******************************************************************************
*                       ******** Watchdog Reset ********
*******************************************************************************/
void WatchdogReset(void)
{
    led1=0; // Turn LED off.
    // Start or restart the watchdog timer interrupt and set to  2000ms.
    osTimerStart(oneShot, 2000); 
}

        
/*******************************************************************************
*                       ******** Watchdog Thread ********
*******************************************************************************/
static void WatchdogThread(void const *argument)
{
    while (true) 
    {
        // Go to sleep until a signal, SignalWatchdog, is received
        osSignalWait(0x01, osWaitForever); 
        led1 = 1;
    }

}


/*******************************************************************************
*                  ******** Watchdog Interrupt Handler ********
*******************************************************************************/
void WatchdogISR(void const *n)
{
    // Send signal to thread with ID, WatchdogId, i.e., WatchdogThread
    osSignalSet(WatchdogId,0x01); 
}
