/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: ExternalInterruptThread.cpp
// file content description:
//      * Function to create the External Interrupt Thread
//      * ExternalInterruptThread
//      * ExternalInterrupt ISR
/******************************************************************************/

#include "mbed.h"

void ExtInterruptISR(void);
void ExtInterruptThread(void const *argument);

osThreadId ExtInterruptId;

osThreadDef(ExtInterruptThread, osPriorityHigh, 1024); // Declare ExtInterruptThread as a thread/process

InterruptIn Bumper(p8); // External interrupt pin declared as Bumper

DigitalOut led2(LED2);


/*******************************************************************************
* @brief    This is the initialization function for ExternalInterruptthread
* @param    none
* @return   none
*******************************************************************************/
void ExternalInterruptThreadInit()
{
    Bumper.rise(&ExtInterruptISR); // Attach the address of the interrupt handler to the rising edge of Bumper
    ExtInterruptId = osThreadCreate(osThread(ExtInterruptThread), NULL);            
}

 
/*******************************************************************************
* @brief    ******** External Interrupt Thread ********
* @param    none
* @return   none
*******************************************************************************/
void ExtInterruptThread(void const *argument)
{
    while (true) {
        osSignalWait(0x01, osWaitForever); // Go to sleep until signal, SignalExtCollision, is received
        led2 = !led2;
    }
}


/*******************************************************************************
* @brief    ******** External Interrupt ISR ********
* @param    none
* @return   none
*******************************************************************************/
void ExtInterruptISR(void)
{
    osSignalSet(ExtInterruptId,0x01); // Send signal to the thread with ID, ExtInterruptId, i.e., ExtInterruptThread.
}
