/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: motor_driver.cpp
// file content description:
//      * function to initialize the hardware used to control a DC Motor
//      * functions to drive to motor in forward, reverse and stop.
/******************************************************************************/

#include "mbed.h"
#include "motor_driver_r.h"



DigitalOut DirR(p29);    // Right motor direction control pin
PwmOut PwmR(p21);       // Right motor PWMz

Mutex SpeedMutexR;

static motor_state_t motor_status = MOTOR_UNINIT;


/*******************************************************************************
* @brief  This function initializes the PWM channel to be used to control a DC
*         motor
* @param  none
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_R_init()
{
    // motor is still uninitialized
    motor_status = MOTOR_UNINIT;

    // DC Motor Control Pins
    DirR = 0;
    PwmR = 0;

    PwmR.period_us(PERIOD_R); // This sets the PWM period in us


    motor_status = MOTOR_INIT;

    return motor_status;

}

/*******************************************************************************
* @brief  This function sets the speed and the direction of the DC motor to move
*         forward
* @param  speed
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_R_forward(int speed)
{

    if( motor_status != MOTOR_UNINIT ) 
    {
        SpeedMutexR.lock();
        DirR = 0;
        PwmR.pulsewidth_us(abs(speed));
        SpeedMutexR.unlock();
        motor_status = MOTOR_FORWARD;
    }

    return motor_status;

}

/*******************************************************************************
* @brief  This function sets the speed and the direction of the DC motor to move
*         backwards
* @param  speed
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_R_reverse(int speed)
{

    if( motor_status != MOTOR_UNINIT ) 
    {
        SpeedMutexR.lock();
        DirR = 1;
        PwmR.pulsewidth_us(abs(speed));
        SpeedMutexR.unlock();
        motor_status = MOTOR_REVERSE;
    }

    return motor_status;

}

/*******************************************************************************
* @brief  This function stops the motor
* @param  none
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_R_stop()
{
    
    if( motor_status != MOTOR_UNINIT ) 
    {
        PwmR.pulsewidth_us(0);
        motor_status = MOTOR_STOPPED;
    }

    return motor_status;

}
