/******************************************************************************/
// ECE4333
// LAB Partner 1:   Ahmed Sobhy - ID: 3594449
// LAB Partner 2:   Brandon Kingman - ID: 3470444
// Project:         Autonomous Robot Design
// Instructor:      Prof. Chris Diduch
/******************************************************************************/
// filename: motor_driver.cpp
// file content description:
//      * function to initialize the hardware used to control a DC Motor
//      * functions to drive to motor in forward, reverse and stop.
/******************************************************************************/

#include "mbed.h"
#include "motor_driver_r.h"
#include "motor_driver_l.h"



DigitalOut DirL(p30);    // Right motor direction control pin
PwmOut PwmL(p22);       // Right motor PWMz

Mutex SpeedMutexL;

static motor_state_t motor_status = MOTOR_UNINIT;


/*******************************************************************************
* @brief  This function initializes the PWM channel to be used to control a DC
*         motor
* @param  none
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_L_init()
{
    // motor is still uninitialized
    motor_status = MOTOR_UNINIT;

    // DC Motor Control Pins
    DirL = 0;
    PwmL = 0;

    PwmL.period_us(PERIOD_L); // This sets the PWM period in us


    motor_status = MOTOR_INIT;

    return motor_status;

}

/*******************************************************************************
* @brief  This function sets the speed and the direction of the DC motor to move
*         forward
* @param  speed
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_L_reverse(int speed)
{

    if( motor_status != MOTOR_UNINIT ) 
    {
        SpeedMutexL.lock();
        DirL = 0;
        PwmL.pulsewidth_us(abs(speed));
        SpeedMutexL.unlock();
        motor_status = MOTOR_FORWARD;
    }

    return motor_status;

}

/*******************************************************************************
* @brief  This function sets the speed and the direction of the DC motor to move
*         backwards
* @param  speed
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_L_forward(int speed)
{

    if( motor_status != MOTOR_UNINIT ) 
    {
        SpeedMutexL.lock();
        DirL = 1;
        PwmL.pulsewidth_us(abs(speed));
        SpeedMutexL.unlock();
        motor_status = MOTOR_REVERSE;
    }

    return motor_status;

}

/*******************************************************************************
* @brief  This function stops the motor
* @param  none
* @return motor_state_t the state of the motor driver
*******************************************************************************/
motor_state_t motorDriver_L_stop()
{
    
    if( motor_status != MOTOR_UNINIT ) 
    {
        PwmL.pulsewidth_us(0);
        motor_status = MOTOR_STOPPED;
    }

    return motor_status;

}
