/* ECE4180 Final Project -- mbed Function Generator
    
   Platform: mbed LPC-1768
    
   Team member: Hanjie Xie
                Qiuyang Tao
                Xuefeng Jin
                Yuqing Peng
*/


#include "mbed.h"
#include "uLCD_4DGL.h"

//----- Objects for devices----------------------
Serial pc(USBTX, USBRX);
uLCD_4DGL lcd(p13, p14, p15);
AnalogOut  aout(p18);


DigitalOut led1(LED1);


//-----Global variable used for Func_Gen---------
const double pi = 3.14;
float time_interv;
int datapoint_counter=0;
int length_waveform=100;
uint16_t waveform[100];
float x;

//-----User Specified, change it if needed-------
int waveform_type; //0 for sine, 
float freq,amp,offset,duty_cycle; 

/*
  sine wave use: freq,amp,offset
  square wave use: freq,amp,offse and duty_cycle
*/


void initialize_LCD(){
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    
    lcd.printf("Initializing...\n");
    lcd.printf("Fun Generator Demo"); 
}

void generate_waveform_datapoints(){ //Generate data points for the waveform
    float t=0;
     
    //------if sine wave--------
    if (waveform_type==0){  
        for (int counter=0; counter<length_waveform; counter++){
            x=amp/3.3*cos(2*pi*freq*t)+offset/3.3;
            waveform[counter]=(uint16_t) (x*65535);      
            t += time_interv;
        }
    }
    
    //------if square wave--------   
    if (waveform_type==1){  
        for (int counter=0; counter<length_waveform; counter++){
            if (counter<=length_waveform*duty_cycle){
                x=amp/3.3+offset/3.3;
            }else{
                x=-1.0*amp/3.3+offset/3.3;
            }
            waveform[counter]=(uint16_t) (x*65535);   
        }           
    }
    
    //------if triangle wave---------  
    if (waveform_type==2){  
        for (int counter=0; counter<length_waveform/2; counter++){
            x=amp/1.65*(2.0*counter/length_waveform-0.5)+offset/3.3;
            waveform[counter]=(uint16_t) (x*65535);   
        } 
        
        for (int counter=length_waveform/2; counter<length_waveform; counter++){
            waveform[counter]=waveform[length_waveform-counter-1];
        } 
                  
    }
}



void output_waveform_datapoints(){  //Output the data points using DAC (pin18)
    for (int counter=0; counter<length_waveform; counter++){
        aout.write_u16(waveform[counter]);
        wait(time_interv);
    } 
}


void output_waveform_datapoints_timer_ISR(){  //Output the data points using DAC (pin18)
        aout.write_u16(waveform[datapoint_counter]);
        datapoint_counter++;
        
        if (datapoint_counter==length_waveform-1){datapoint_counter=0;}
}



void display_on_lod() {
    int lcd_counter=0;
    while (true) {
        lcd.locate(4,4);
        lcd.printf("%d",lcd_counter);
        lcd_counter++;
    }
}


 
int main(void){
    initialize_LCD();
    
    waveform_type=0; //0 for sine, 
    freq=1000; //Hz
    amp=1.65; //Sacle factor, 1=full range
    offset=1.65;
    duty_cycle=0.2;
    
    time_interv=1.0/freq/length_waveform;
    
    
    generate_waveform_datapoints();
    

    while (1){
        output_waveform_datapoints();
    }
}
