/*
* menu.cpp
* Author: Hanjie Xie
*/

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "menu.h"
#include "para.h"
uLCD_4DGL uLCD(p9,p10,p11);
DigitalIn left_pb1(p21);
DigitalIn right_pb1(p23);
DigitalIn fire_pb1(p22);
DigitalIn toggle_pb1(p24);

int start_enable;
int rules_display;
int dev_display;
int go_to_quit;
// declare the class
para mypara;

int begain_first(){
    left_pb1.mode(PullUp);
    right_pb1.mode(PullUp);
    fire_pb1.mode(PullUp);
    toggle_pb1.mode(PullUp);
    display_beginning();
    while(1){
        display_main_menu();
        choose();
        check();
        if(start_enable==1){
            break;
        }   
    }
    return 1;
}

int return_menu(){
    uLCD.cls();
    while(1){
        display_main_menu();
        choose();
        check();
        if(start_enable==1){
            para_setting();
            return 1;
        }   
    }  
}   
    
void display_beginning(){
    uLCD.color(RED);
    uLCD.printf("\nWelcome\n"); //Default Green on black text
    uLCD.printf("\nTo\n"); //Default Green on black text
    uLCD.printf("\nMbed\n");
    uLCD.printf("\nFunction Genator!\n");
    wait(2);
    uLCD.cls();

}

void display_main_menu(){
    uLCD.locate(4,3);
    uLCD.printf("\n  Let's Start!\n");
    uLCD.locate(4,5);
    uLCD.printf("\n  How to use?\n");
    uLCD.locate(4,7);
    uLCD.printf("\n  Developer\n");
    uLCD.locate(4,9);
    uLCD.printf("\n  Quit.\n"); 
    uLCD.color(GREEN);
    uLCD.locate(4,12);
    uLCD.printf("\n  OK  UP  DOWN \n"); 
    uLCD.filled_circle(20,100,2,GREEN);
    uLCD.filled_circle(50,100,2,GREEN);
    uLCD.filled_circle(80,100,2,GREEN);
    uLCD.filled_circle(110,100,2,GREEN);
    wait(1);
}
    
void choose(){
    start_enable = 0;
    rules_display = 0;
    dev_display = 0;
    go_to_quit = 0;
    int circle_y = 35;
    uLCD.filled_circle(10,35,2,BLUE); //51 67 83 +16
    int choose = 0;
    while(choose == 0){
        if(left_pb1 == 0){
            choose = 1;
            if(circle_y == 35){
                start_enable = 1;
            }else if(circle_y == 51){
                rules_display = 1;
            }else if(circle_y == 67){
                dev_display = 1;
            }else if(circle_y == 83){
                go_to_quit = 1;
            }
            uLCD.cls();
        } 
        if(fire_pb1 == 0){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y > 35){
               circle_y = circle_y-16;
           }
           uLCD.filled_circle(10,circle_y,2,BLUE);
        }   
        if(right_pb1 == 0){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y < 80){
               circle_y = circle_y+16; 
           }  
           uLCD.filled_circle(10,circle_y,2,BLUE);     
        }
    }
}    
 
void check(){   
     if(rules_display == 1){
       /****************************************
       FIND A CONTROL RULE
       *****************************************/
    } else if(dev_display == 1){
       uLCD.locate(4,3);
       uLCD.printf("\n  JIN XUEFEN\n");
       uLCD.locate(4,5);
       uLCD.printf("\n  PENG YUQING\n");
       uLCD.locate(4,7);
       uLCD.printf("\n  TAO QIUYANG\n");
       uLCD.locate(4,9);
       uLCD.printf("\n  XIE HANJIE\n"); 
       wait(5);
       uLCD.cls();
    } else if(go_to_quit == 1){
        uLCD.printf("\nBye\n");
        exit(0);
    }
}

para para_setting() {
    mode_set();
    freq_set();
    amp_set();
    //offset_set();
    para_display();
    return mypara;
}

void mode_set() {
    uLCD.locate(4,3);
    uLCD.printf("\n   Sine wave\n");
    uLCD.locate(4,5);
    uLCD.printf("\n   Square wave\n");
    uLCD.locate(4,7);
    uLCD.printf("\n   Tringle wave\n");
    int circle_y = 35;
    uLCD.filled_circle(10,35,2,BLUE); //51 67 83 +16
    int choose = 0;
    while(choose == 0){
        if(left_pb1 == 0){
            choose = 1;
            int type = (circle_y - 35) / 16;
            mypara.set_type(type);
            uLCD.cls();
        } 
        if(fire_pb1 == 0){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y > 35){
               circle_y = circle_y-16;
           }
           uLCD.filled_circle(10,circle_y,2,BLUE);
        }   
        if(right_pb1 == 0){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y < 62){
               circle_y = circle_y+16; 
           }  
           uLCD.filled_circle(10,circle_y,2,BLUE);     
        }
    }
}

void freq_set() {
    /*
    int kilodig;
    int hunddig;
    int tensdig;
    int unit;
    uLCD.locate(4,3);
    uLCD.printf("\n  kilo place:");
    uLCD.locate(4,5);
    uLCD.printf("\n  hundreds place:\n");
    uLCD.locate(4,7);
    uLCD.printf("\n  tens placen:");
    uLCD.locate(4,9);
    uLCD.printf("\n  unit:\n"); 
    */
    int choose = 0;
    float increment = 100;
    uLCD.locate(1,3);
    uLCD.printf("\nSet the frequency:\n");
    while(choose == 0){
        uLCD.locate(4,5);
        uLCD.printf("\n%.0f    \n", mypara.get_freq());
        if(left_pb1 == 0){
            choose = 1;
            uLCD.cls();
        } 
        if(fire_pb1 == 0){
           float temp = mypara.get_freq();
           temp += increment;
           mypara.set_freq(temp);
        }   
        if(right_pb1 == 0){
           float temp = mypara.get_freq();
           temp -= increment;
           mypara.set_freq(temp);
        }
        wait(0.2);
    }
}

void amp_set() {
    int choose = 0;
    uLCD.locate(1,3);
    uLCD.printf("\nSet the amplitude:\n");
    float increment = 0.5;
    while(choose == 0){
        uLCD.locate(4,5);
        uLCD.printf("\n%.2f    \n", mypara.get_amp());
        if(left_pb1 == 0){
            choose = 1;
            uLCD.cls();
        } 
        if(fire_pb1 == 0){
           float temp = mypara.get_amp();
           temp += increment;
           mypara.set_amp(temp);
        }   
        if(right_pb1 == 0){
           float temp = mypara.get_amp();
           temp -= increment;
           mypara.set_amp(temp);
        }
        wait(0.2);
    }
}

  

void para_display() {
    uLCD.locate(4,3);
    uLCD.printf("\n 1.Type: %d\n", mypara.get_type());
    uLCD.locate(4,5);
    uLCD.printf("\n 2.Frequency: %d\n", mypara.get_freq());
    uLCD.locate(4,7);
    uLCD.printf("\n 3.Amplitude: %.2f\n", mypara.get_amp());
    //uLCD.locate(4,9);
    //uLCD.printf("\n 4.Offset: %.2f\n", mypara.get_offset());
}