/*
* menu.cpp
* Author: Hanjie Xie
*/

#include "mbed.h"
#include "uLCD_4DGL.h"
#include "menu.h"
#include "para.h"
#include <mpr121.h>

uLCD_4DGL uLCD(p13,p14,p15);
//touch pad declare
InterruptIn interrupt(p26);// Create the interrupt receiver object on pin 26
I2C i2c(p9, p10);// Setup the i2c bus on pins 28 and 27
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

// for test use
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn pb(p21);
/*
DigitalIn left_pb1(p21);
DigitalIn right_pb1(p23);
DigitalIn fire_pb1(p22);
DigitalIn toggle_pb1(p24);
*/
int start_enable;
int rules_display;
int dev_display;
int go_to_quit;
// declare the class
para mypara;

int keypress = 100;
bool toggle = 0;
void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    keypress = key_code - 1;
    toggle = !toggle;
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}

int begain_first(){
    int mode;
    pb.mode(PullUp);
    /*
    left_pb1.mode(PullUp);
    right_pb1.mode(PullUp);
    fire_pb1.mode(PullUp);
    toggle_pb1.mode(PullUp);*/
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    mode = display_beginning();
    while(mode == 1){
        display_main_menu();
        choose();
        check();
        if(start_enable==1){
            break;
        }   
    }
    while (mode == 0) {
        uLCD.printf("PC MODE");
    }
    return mode;
}

int return_menu(){
    uLCD.cls();
    while(1){
        display_main_menu();
        choose();
        check();
        if(start_enable==1){
            para_setting();
            return 1;
        }   
    }  
}   
    
int display_beginning(){
    uLCD.color(RED);
    uLCD.printf("\nWelcome\n"); //Default Green on black text
    uLCD.printf("\nTo\n"); //Default Green on black text
    uLCD.printf("\nMbed\n");
    uLCD.printf("\nFunction Genator!\n");
    wait(2);
    uLCD.cls();
    uLCD.printf("\nChoose your control mode\n");
    uLCD.locate(0,5);
    uLCD.printf("\n1. mbed mode\n");
    uLCD.locate(0,7);
    uLCD.printf("\n2. PC mode\n");
    int choose = 0;
    int mode = 0;
    while(choose == 0){
        //pc.printf("\nkeypress is: %d\n", keypress);
        if (keypress == 1) {
            choose = 1;
            mode = 1;
        }
        if (keypress == 2) {
            choose = 1;
            mode = 0;
        }
    }
    return mode;
}

void display_main_menu(){
    uLCD.cls();
    uLCD.color(GREEN);
    uLCD.locate(0,3);
    uLCD.printf("\n1. Let's Start!\n");
    uLCD.locate(0,5);
    uLCD.printf("\n2. How to use?\n");
    uLCD.locate(0,7);
    uLCD.printf("\n3. Developer\n");
    uLCD.locate(0,9);
    uLCD.printf("\n4. Quit.\n"); 
    /*uLCD.locate(4,12);
    uLCD.printf("\n  OK  UP  DOWN \n"); 
    uLCD.filled_circle(20,100,2,GREEN);
    uLCD.filled_circle(50,100,2,GREEN);
    uLCD.filled_circle(80,100,2,GREEN);
    uLCD.filled_circle(110,100,2,GREEN);*/
    wait(1);
}
    
void choose(){
    start_enable = 0;
    rules_display = 0;
    dev_display = 0;
    go_to_quit = 0;
    //int circle_y = 35;
    //uLCD.filled_circle(10,35,2,BLUE); //51 67 83 +16
    int choose = 0;
    while(choose == 0){
        pc.printf("\nkeypress is: %d\n", keypress);
        if (keypress == 1) {
            choose = 1;
            start_enable = 1;
        }
        if (keypress == 2) {
            choose = 1;
            rules_display = 1;
        }
        if (keypress == 3) {
            choose = 1;
            dev_display = 1;
        }
        if (keypress == 4) {
            choose = 1;
            go_to_quit = 1;
        }
        /*
        if(keypress == 1){
            choose = 1;
            if(circle_y == 35){
                start_enable = 1;
            }else if(circle_y == 51){
                rules_display = 1;
            }else if(circle_y == 67){
                dev_display = 1;
            }else if(circle_y == 83){
                go_to_quit = 1;
            }
            uLCD.cls();
        } 
        if(keypress == 2){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y > 35){
               circle_y = circle_y-16;
           }
           uLCD.filled_circle(10,circle_y,2,BLUE);
        }   
        if(keypress == 3){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y < 80){
               circle_y = circle_y+16; 
           }  
           uLCD.filled_circle(10,circle_y,2,BLUE);     
        }*/
    }
}    
 
void check(){   
     if(rules_display == 1){
       uLCD.printf("Follow the instruction on each page");
       wait(5);
       uLCD.cls();
    } else if(dev_display == 1){
       uLCD.cls();
       uLCD.locate(4,3);
       uLCD.printf("\n  JIN XUEFEN\n");
       uLCD.locate(4,5);
       uLCD.printf("\n  PENG YUQING\n");
       uLCD.locate(4,7);
       uLCD.printf("\n  TAO QIUYANG\n");
       uLCD.locate(4,9);
       uLCD.printf("\n  XIE HANJIE\n"); 
       wait(5);
       uLCD.cls();
    } else if(go_to_quit == 1){
        uLCD.printf("\nBye\n");
        exit(0);
    }
}

para para_setting() {
    mode_set();
    freq_set();
    amp_set();
    //offset_set();
    para_display();
    return mypara;
}

void mode_set() {
    uLCD.cls();
    uLCD.locate(0,1);
    uLCD.printf("Select a wave form");
    uLCD.color(GREEN);
    uLCD.locate(0,3);
    uLCD.printf("\n1.Sine wave\n");
    uLCD.locate(0,5);
    uLCD.printf("\n2.Square wave\n");
    uLCD.locate(0,7);
    uLCD.printf("\n3.Tringle wave\n");
    uLCD.locate(0,12);
    uLCD.printf("\nK11:Reset\n");
    int choose = 0;
    while(choose == 0){
        if(keypress == 1){
            choose = 1;
            mypara.set_type(0);
        } 
        if(keypress == 2){
          choose = 1;
            mypara.set_type(1);
        }   
        if(keypress == 3){
           choose = 1;
            mypara.set_type(2);
        }
        if(keypress == 11){
           return_menu();
        }
    }
    /*
    int circle_y = 35;
    uLCD.filled_circle(10,35,2,BLUE); //51 67 83 +16
    int choose = 0;
    while(choose == 0){
        if(keypress == 1){
            choose = 1;
            int type = (circle_y - 35) / 16;
            mypara.set_type(type);
            uLCD.cls();
        } 
        if(keypress == 2){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y > 35){
               circle_y = circle_y-16;
           }
           uLCD.filled_circle(10,circle_y,2,BLUE);
        }   
        if(keypress == 3){
           uLCD.filled_circle(10,circle_y,2,BLACK);
           wait(0.2);
           if(circle_y < 62){
               circle_y = circle_y+16; 
           }  
           uLCD.filled_circle(10,circle_y,2,BLUE);     
        }
    }
    */
}

void freq_set() {
    /*
    int kilodig;
    int hunddig;
    int tensdig;
    int unit;
    uLCD.locate(4,3);
    uLCD.printf("\n  kilo place:");
    uLCD.locate(4,5);
    uLCD.printf("\n  hundreds place:\n");
    uLCD.locate(4,7);
    uLCD.printf("\n  tens placen:");
    uLCD.locate(4,9);
    uLCD.printf("\n  unit:\n");
    */
    uLCD.cls();
    uLCD.color(GREEN);
    int choose = 0;
    //float increment = 100;
    uLCD.locate(0,0);
    uLCD.printf("\nSet the frequency:\n");
    uLCD.printf("\nRange from 0-3MHz\n");
    uLCD.locate(4,12);
    uLCD.printf("\nK10:OK K11:reset");
    uLCD.locate(0,7);
    uLCD.color(BLUE);
    uLCD.printf("\nInput your value: \n");
    int temp = 0;
    bool tem_tog = toggle;
    while(choose == 0){
        if (keypress != 100 && tem_tog != toggle && keypress == -1 && keypress != 10) {tem_tog = toggle;}
        if (keypress != 100 && tem_tog != toggle && keypress != -1 && keypress != 10){
            tem_tog = toggle;
            uLCD.printf("%d", keypress);
            temp = temp * 10 + keypress;
            wait(0.2);
        }
        if(keypress == 10){
            choose = 1;
            mypara.set_freq(temp);
        }
        if(keypress == 11){
           return_menu();
        }
    }
}

void amp_set() {
    int choose = 0;
    uLCD.cls();
    uLCD.color(GREEN);
    uLCD.locate(0,0);
    uLCD.printf("\nSet the amplitude:\n");
    uLCD.locate(0,3);
    uLCD.printf("\nRange from 0 - 5v\n");
    uLCD.locate(0,12);
    uLCD.printf("\nK11:reset");
    uLCD.locate(0,7);
    uLCD.color(BLUE);
    uLCD.printf("\nInput your value: \n");
    float temp = 0;
    int tem_tog = toggle;
    int decpoint = 0;
    while(choose == 0){
        if (keypress != 100 && tem_tog != toggle && keypress == -1 && keypress != 10) {tem_tog = toggle;}
        if (keypress != 100 && tem_tog !=toggle && keypress != -1) {
            if(keypress == 11){
                return_menu();
            }
            tem_tog = toggle;
            if(decpoint == 0) {
                uLCD.printf("%d", keypress);
                temp = (float)keypress;
                decpoint = 1;
            } else {
               uLCD.printf(".%d", keypress);
               temp = temp + (float)0.1 * keypress;
               choose = 1;
               mypara.set_amp(temp);
            }
            wait(0.2);
        }
    }
}

  

void para_display() {
    uLCD.cls();
    uLCD.color(GREEN);
    uLCD.locate(0,0);
    switch ( mypara.get_type()){
    case 1: uLCD.printf("\n 1.Type: sine\n");break;
    case 2: uLCD.printf("\n 1.Type: square\n");break;
    case 3: uLCD.printf("\n 1.Type: tringle\n");break;
    }
    uLCD.locate(0,3);
    uLCD.printf("\n 2.Frequency:%d\n", mypara.get_freq());
    uLCD.locate(0,6);
    uLCD.printf("\n 3.Amplitude:%.1f\n", mypara.get_amp());
    uLCD.color(RED);
    uLCD.locate(0,8);
    uLCD.printf("\n Your wave is out from P29");
    uLCD.color(GREEN);
    uLCD.locate(0,12);
    uLCD.printf("\n K11:Reset");
    while (1) {
        if(keypress == 11){
            return_menu();
        }
    }
}