#include "mbed.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX); // tx, rx

extern "C" void mbed_mac_address(char *mac);
 
int main() {
    
    // to get the mac address of the mbed
    char mac[6];
    mbed_mac_address(mac);
    for(int i=0; i<6;i++) {
        printf("%02X ", mac[i]);
    }
    printf("\n");

    EthernetInterface eth;
    eth.init(); //Use DHCP
    
    pc.printf("Testing Init");
    int err = eth.connect(15000);
    if (err != 0 ) {
        pc.printf("Error in connection error code is  %d. \n", err);
    } else {
       // exit(1);
    }
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketConnection sock;
    sock.connect("mbed.org", 80);
    
    char http_cmd[] = "GET /media/uploads/mbed_official/hello.txt HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}
