// LSM9DS90/uLCD Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "LSM9DS0.h"
#include "uLCD_4DGL.h"

// uncomment this line to enable the uLCD for Part 4 of the lab
#define PART_4

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 500

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);

#ifdef PART_4
uLCD_4DGL lcd(p28, p27, p30);
#endif

//Init Serial port and LSM9DS0 chip
void setup()
{
#ifdef PART_4
	lcd.baudrate(3000000);
	lcd.background_color(0);
	lcd.cls();
	lcd.printf("Initializing...");
#endif

	// Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS0 WHO_AM_I's returned: 0x%X\n", status);
    pc.printf("Should be 0x49D4\n\n");
}

int main()
{
    setup();  //Setup sensor and Serial
    pc.printf("------ LSM0DS0 Demo -----------\n");
    lcd.cls();
    lcd.circle(64, 64, 63, WHITE);
    float fx = 64.0, fy = 64.0;
    int x = 64, y = 64, radius = 4;
	float vx, vy;
	
    while (true)
    {
    	// Compass Trigonometry tip: you can retrieve the compass heading (in degrees) directly from
    	// the IMU library. Example:
    	// 		imu.readMag();
    	//		float heading = imu.calcHeading();
    	// Remember that x = length*cos(heading) and y = length*sin(heading)
    	// to convert from degrees to radians (for sin/cos functions), multiply by pi/180
    	
    	// Part 2 read compass heading, accelerometer data, and temperature
    	// and print it to the USB serial port
    	imu.readGyro();
    	imu.readMag();
	    imu.readAccel();
	    float heading = imu.calcHeading(); //calculate compass heading
	    imu.readTemp();
	    pc.printf("Compass heading: %2f\n", heading);
	    pc.printf("Accelerometer data: %2f, %2f, %2f\n", imu.ax, imu.ay, imu.az);
	    pc.printf("Temperature in Fahr: %3.2f\n", imu.temperature_f);
	    
	    //Part3 display through real serial COM
	   //pc.printf("C: %2f\n", heading);
	   //pc.printf("A: %2f, %2f, %2f\n", imu.ax, imu.ay, imu.az);
	   //pc.printf("T: %3.2f\n", imu.temperature_f);
	
		//Part4 display bubble level on the uLCD
		
		lcd.filled_circle(x, y, radius, RED);
		wait(0.5);
		vx = imu.ax * 58;
		vy = imu.ay * 58;
		lcd.filled_circle(x, y, radius, BLACK);
		fx = 64 - vx;
		fy = 64 + vy;
		x = int(fx);
		y = int(fy);
		
		//
	
		wait_ms(REFRESH_TIME_MS);
	}
}
