#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

uLCD_4DGL myLCD(p9, p10, p11);
Mutex lcd_mutex;

PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p22);
PwmOut RGBLED_b(p21);

SDFileSystem sd(p5, p6, p7, p8, "sd");

AnalogOut Speaker(p18);
wave_player waver(&Speaker);
bool  PLAY = true;
bool  *PlayStopPtr = &PLAY;

int j = 0;
int k = 0;

void ulcd1_thread(void const *args) {
    while(true) {
        lcd_mutex.lock();
        myLCD.locate(0,0);
        myLCD.printf("Thread1 status count: %d", j);
        lcd_mutex.unlock();
        j++;
        Thread::wait(150);
    }
}

void ulcd2_thread(void const *args) {
    while(true) {
        lcd_mutex.lock();
        myLCD.locate(0,5);
        myLCD.printf("Thread 2 status count : %d", k);
        lcd_mutex.unlock();
        k++;
        Thread::wait(300);
    }
}

void led_thread(void const *args) {
    while(true) {
        RGBLED_g = 0.0;
        RGBLED_r = 1.0;
        RGBLED_b = 0.0;
        Thread::wait(300);
        RGBLED_r = 0.0;
        RGBLED_b = 1.0;
        Thread::wait(300);
    }
}

void Speaker_thread(void const *args) {
    while(true) {
        FILE *wave_file;
        wave_file=fopen("/sd/mySound/Siren.wav","r");
        waver.play(wave_file,PlayStopPtr);
        fclose(wave_file);
        Thread::wait(1000);    // wait 1.0s
    }
}
 
int main() {
    
    myLCD.cls();
    
    Thread thread0(ulcd1_thread);
    Thread thread1(ulcd2_thread);
    Thread thread2(led_thread);
    Thread thread3(Speaker_thread);
    
    Timer t;
    t.start();
    while (true) {
        lcd_mutex.lock();
        myLCD.locate(0,9);
        myLCD.printf("The time taken was %0.2f seconds\n", t.read());
        lcd_mutex.unlock();
        Thread::wait(500);
    }
}
