#include "mbed.h"
 
// A class for flip()-ing a DigitalOut 
class Flipper {
public:
    Flipper(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void flip() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};
 
Flipper f_1(LED1);
Flipper f_2(LED2);
Flipper f_3(LED3);
Flipper f_4(LED4);

Ticker t_1;
Ticker t_2;
Ticker t_3;
Ticker t_4;
 
int main() {
    t_1.attach(&f_1, &Flipper::flip, 1.0); 
    t_2.attach(&f_2, &Flipper::flip, 2.0); // the address of the object, member function, and interval
    t_3.attach(&f_3,&Flipper::flip,3.0);
    t_4.attach(&f_4, &Flipper::flip, 4.0); 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) 
        {
        }
}
