#include "mbed.h"

DigitalOut dout1(LED1);
DigitalOut dout2(LED2);
DigitalOut dout3(LED3);
DigitalOut dout4(LED4);
AnalogIn ain(p15);
// The sinewave is created on this pin
AnalogOut aout(p18);

int main()
{
    const double pi = 3.141592653589793238462;
    const double amplitude = 0.5f;
    const double offset = 65535/2;
    double rads = 0.0;
    uint16_t sample = 0;
    
    while(1) {
        // sinewave output
        for (int i = 0; i < 360; i++) {
            rads = (pi * i) / 180.0f;
            sample = (uint16_t)(amplitude * (offset * (cos(rads + pi))) + offset);
            aout.write_u16(sample);
        }
        
        //Sharp IR sensor display
        if (ain.read() > 0.9f) //less than 7 cm
        {
            dout1 = 1;
            dout2 = 1;
            dout3 = 1;
            dout4 = 1;
        }
        else if (ain.read() > 0.68f && ain.read() <= 0.9f) //7-10
        {
            dout1 = 0;
            dout2 = 1;
            dout3 = 1;
            dout4 = 1;
        }
        else if (ain.read() > 0.53f && ain.read() <= 0.68f) //10-13
        {
            dout1 = 0;
            dout2 = 0;
            dout3 = 1;
            dout4 = 1;
        }
        else if (ain.read() > 0.45f && ain.read() <= 0.53f) //13-17
        {
            dout1 = 0;
            dout2 = 0;
            dout3 = 0;
            dout4 = 1;
        }
        else //greater than 17
        {
            
            dout1 = 0;
            dout2 = 0;
            dout3 = 0;
            dout4 = 0;
        }
    }
}
