#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SongPlayer.h"
#include "PinDetect.h"
#include "string.h"
#include "EthernetInterface.h"
#include "Speaker.h"

//uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
uLCD_4DGL uLCD(p28, p27, p29); 
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
DigitalOut latch(p15);
DigitalOut enable(p16);
//AnalogOut DACout(p18);
//Cycles through different colors on RGB LED
SPI spi(p11, p12, p13);
//Set up IR sensor 
AnalogIn IrSensor(p20);
Serial serial(USBTX, USBRX);

SongPlayer mySpeaker(p26);
Speaker NotePlayer(p26);

// ethernet setup    
EthernetInterface eth;

DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);

PinDetect pb1(p21);
PinDetect pb2(p22);
PinDetect pb3(p23);
PinDetect pb4(p24);


//void Thread_maintnence(char Thread); 
void init_pbs(void);
enum Statetype { Armed =0 ,IR_sensed = 1,Second_Step = 2,Cleared = 3, Alarm_ON = 4};
Statetype state = Armed;

int Code[4] = {0,0,0,0}; 
int CodeCounter = 0; 

void pb1_hit_callback (void) {
    if ((state == IR_sensed) ||(state == Cleared)) {
    NotePlayer.PlayNote(1200.0,0.15,0.1);
    Code[CodeCounter] = 1;
    CodeCounter++;
    wait(0.500);
    }
}
void pb2_hit_callback (void) {
    if ((state == IR_sensed) ||(state == Cleared)){
    NotePlayer.PlayNote(1200.0,0.15,0.1);
    Code[CodeCounter] = 2;
    CodeCounter++;
    wait(0.500);
    }
}
void pb3_hit_callback (void) {
    if ((state == IR_sensed) ||(state == Cleared)) {
    NotePlayer.PlayNote(1200.0,0.15,0.5);
    Code[CodeCounter] = 3;
    CodeCounter++;
    wait(0.500);
    }
}
void pb4_hit_callback (void) {
   if ((state == IR_sensed) ||(state == Cleared)) {
       NotePlayer.PlayNote(1200.0,0.15,0.5);
        Code[CodeCounter] = 4;
        CodeCounter++;
   wait(0.500);
   }
}

Mutex LCD_Access; 
Semaphore Consul_Access(5);
float IrVoltage = 0.0;

float note[18]= {1568.0,1396.9};
float duration[18]= {0.48,0.24};



void init_LCD();
void RGB_LED(int red, int green, int blue);
    
void Speaker_thread(void const *args) {
    while (1) {
    if (state == Alarm_ON) {
        mySpeaker.PlaySong(note,duration);
        Thread::wait(1000); 
        }
    }
}

void uLCD_thread(void const *args) {
    int Change = 99; 
    while(1) {
        
        if (Change != state) {
            Change = state;
            switch (state) {
                case Armed:
                    LCD_Access.lock();
                    uLCD.cls();
                    uLCD.color(WHITE);
                    uLCD.text_width(2);
                    uLCD.text_height(2);
                    uLCD.printf("  ARMED\r\n");
                    uLCD.text_width(1); 
                    uLCD.text_height(1);
                   
                    if (eth.getIPAddress() == "\0") {
                        uLCD.printf("\n\n No Internet connection");
                        }
                    else {
                        uLCD.printf("\n\nConnected to the  Internet\n");
                        uLCD.printf("IP Address:%sabcd ", eth.getIPAddress());
                        }
                    LCD_Access.unlock();
                break;
                case IR_sensed:
                    LCD_Access.lock();
                    uLCD.cls();
                    uLCD.printf("\nSensor triggred \n"); 
                    uLCD.printf("\n  Enter the code ...");
                    LCD_Access.unlock();
                    for (int i=30; i>=0; --i) {
                        if (state == IR_sensed) {
                            LCD_Access.lock();
                            uLCD.text_width(4);
                            uLCD.text_height(4);
                            uLCD.color(RED);
                            uLCD.locate(1,2);
                            uLCD.printf("%2D",i);                    
                            LCD_Access.unlock();                    
                            Thread::wait(1000);
                            }
                        }
                        if (state == IR_sensed) {
                            state = Alarm_ON;
                            }

                break;
                case Second_Step: 
                    LCD_Access.lock();
                    uLCD.cls();
                    uLCD.color(BLUE);
                    uLCD.printf("\nPleas enter code from text massage \n");
                    LCD_Access.unlock();
                    break;
                case Alarm_ON:
                    LCD_Access.lock();
                    uLCD.cls();
                    uLCD.color(RED);
                    uLCD.text_width(1.5); //4X size text
                    uLCD.text_height(1.5);
                    uLCD.printf("\nALARM IS ON \nText message sent \n"); 
                    LCD_Access.unlock();
                    break;
                case Cleared: 
                    LCD_Access.lock();
                    uLCD.cls();
                    uLCD.color(GREEN);
                    uLCD.printf("\n\nAccess Granted. \n\n"); 
                    LCD_Access.unlock();  
                break; 
                }
            }
            Thread::wait(500);
        }
}

void IR_thread(void const *args) {
    
    Timer t;
    t.start(); 
    
    while(1) {
        
        if (state == Armed) {
            IrVoltage=IrSensor.read();
            if (IrVoltage <= 0.1) { //if value just nois reset timer
                t.reset();
                state = Armed;
                }
            if (t.read() >= 5) { //wait 5 seconds to make sure that sense someone 
                state = IR_sensed; 
                }
            Thread::wait(1000);
        }
        else {
            //nothing to do for this thread make space for others
            Thread::wait(1000);
        }
    }
}

void Shiftbright_thread(void const *args){
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    
    while(1) {
    switch (state) {
        case Armed:
            for (int i = 0; i <= 50; i++) {
                RGB_LED( i, 0, 0);
                Thread::wait(10);
            }
            for (int i = 50; i >= 0; i--) {
                RGB_LED( i, 0, 0);
                Thread::wait(10);
            }
        break;
        case IR_sensed:
            RGB_LED( 100, 0, 0);
            Thread::wait(500);
            RGB_LED( 0, 0, 0);
        break;
        case Alarm_ON:
            for (int i = 0; i <= 100; i++) {
                RGB_LED( i, i/2, 0);
                Thread::wait(10);
            }
            for (int i = 100; i >= 0; i--) {
                RGB_LED( i, i/3, 0);
                Thread::wait(10);
            }
        break; 
        case Cleared:
            RGB_LED( 0, 100, 0);
            break;
        }
        Thread::wait(1000);
   }
}

void CheckCode_thread(void const *args) {
    while(1){
        switch (state) {
            case Armed:
            break;
            case IR_sensed:
                if ((Code[0] == 1) &&  (Code[1] == 2) && (Code[2] == 3) && (Code[3] == 4)) {
                    Thread::wait(300);
                    state = Cleared; 
                    Code[0] = Code[1] = Code[2] = Code[3] =0;
                    CodeCounter = 0;
                    break;
                }
                else if ((Code[0] != 0) &&  (Code[1] != 0) && (Code[2] != 0) && (Code[3] != 0)) {
                    Thread::wait(300);
                    Code[0] = Code[1] = Code[2] = Code[3] =0;
                    NotePlayer.PlayNote(200,1,0.5);
                    state = Alarm_ON; 
                }
                //Thread::wait(100);
            break;
            case Alarm_ON: 
                Thread::wait(1000);
            break; 
            case Cleared: 
                //serial.printf("CC from check: %d%d%d%d\n\r",Code[0],Code[1],Code[2],Code[3]);
                if ((Code[0] == 4) &&  (Code[1] == 3) && (Code[2] == 2) && (Code[3] == 1)) {
                    Thread::wait(300);
                    Code[0] = Code[1] = Code[2] = Code[3] =0;
                    CodeCounter = 0;
                    state = Armed; 
                    break;
                    }
                else if ((Code[0] != 0) &&  (Code[1] != 0) && (Code[2] != 0) && (Code[3] != 0)) {
                    Thread::wait(300);
                    Code[0] = Code[1] = Code[2] = Code[3] =0;
                    NotePlayer.PlayNote(200,1,0.5);
                    CodeCounter = 0;
                //state = Alarm_ON; 
                }
                //Thread::wait(100);
            break;
        }
    }
}

void Ethernet_thread(void const *args) { 
    
    int Change = 99; 
    
    eth.init(); //Use DHCP
    eth.connect();
    serial.printf("IP Address is: %s", eth.getIPAddress());
    
    while(1) {
        if (Change != state) {
             
            Change = state;
            switch (state) {
                case Armed:
                    //add code that verifies connection every so often 
                    Thread::wait(1000);
                break;
                case Second_Step: 
                    Thread::wait(1000);
                break;
                case Alarm_ON: {
                // send alert
                    char buffer[300];
                    int ret;
                    TCPSocketConnection sock;
                    sock.connect("dreamphysix.com", 80);

                    char http_cmd[] = "GET http://dreamphysix.com/alert.php?authcode=0e9cae34a0 HTTP/1.0\n\n";
                    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    

                    while (true) {
                        ret = sock.receive(buffer, sizeof(buffer)-1);
                        if (ret <= 0)
                            break;
                        buffer[ret] = '\0';
                        Consul_Access.wait();
                       serial.printf("Received %d chars from server:\n%s\n", ret, buffer);
                        Consul_Access.release();
                        }
                    sock.close();
                    }
                break;
                case Cleared:
                    //nothing to do for this thread make space for others 
                    Thread::wait(1000);
                break;
                case IR_sensed:
                    //nothing to do for this thread make space for others
                    Thread::wait(1000);
                break;
            }
        }
    }   
}
  
void LCD_Code_Enter_Thread(void const *args) {
    int LineHight = 120;
    int LineWidth = 10; 
    int SpaceWidth = 5;
    int MidPoint = 127/2;
    while(1) {
        switch (state) {
                case Armed:
                break;
                case IR_sensed:
                case Cleared:
                    
                    Thread::wait(500);
                    while((state == IR_sensed)||(state == Cleared)) {
                        LCD_Access.lock();
                        //dusplay four lines 
                        uLCD.line(MidPoint-2*(LineWidth+SpaceWidth), LineHight, MidPoint- 2*SpaceWidth-LineWidth, LineHight, WHITE); //line( int x1, int y1, int x2, int y2, int color)
                        uLCD.line(MidPoint-LineWidth-SpaceWidth, LineHight, MidPoint-SpaceWidth, LineHight, WHITE); //line( int x1, int y1, int x2, int y2, int color)
                        uLCD.line(MidPoint+SpaceWidth, LineHight, MidPoint+SpaceWidth+LineWidth, LineHight, WHITE); //line( int x1, int y1, int x2, int y2, int color)
                        uLCD.line(MidPoint+2*SpaceWidth+LineWidth, LineHight, MidPoint+2*(SpaceWidth+LineWidth), LineHight, WHITE); //line( int x1, int y1, int x2, int y2, int color)
                        uLCD.locate(5,14);
                        uLCD.text_width(1); //4X size text
                        uLCD.text_height(1);
                        uLCD.color(WHITE);
                        uLCD.printf("%d %d  %d %d",Code[0],Code[1],Code[2],Code[3]);
                        LCD_Access.unlock();
                    }
                case Second_Step:
                break; 
                case Alarm_ON:
                break;
                }
        }
}
    
int main() {
    
    serial.baud(921600);
    init_pbs();
    
    Thread Ethernetthread(Ethernet_thread);
    wait(5); //Give the Ethernet connection some time to set up 
    
    Thread LCDthread(uLCD_thread);
    Thread IRthread(IR_thread);
    Thread Shiftbright(Shiftbright_thread);
    Thread Speakerthread(Speaker_thread);
    Thread CheckCode(CheckCode_thread);
    Thread LCD_CodeEnterThread(LCD_Code_Enter_Thread); 
    
    while (true) { }
}

void init_LCD() {
    uLCD.baudrate(3000000);
    uLCD.background_color(BLACK);
}
    
void RGB_LED(int red, int green, int blue) {
    
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
    
    }
void init_pbs(void) {
    // Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    // pushbuttons now setup and running
}