/* Written by Autumn Caraway
ECE 4180 Final Project
Sliding Camera Rail

Souce code for the camera rail controller
*/

#include "mbed.h"
#include "DebounceIn.h"
 
 // Joystick
AnalogIn xAxis(p19);
AnalogIn yAxis(p20);   // Initialized but unused
InterruptIn select(p18);

// XBEE
//Serial xbee(USBTX, USBRX);
Serial xbee(p28, p27);
DigitalOut xb_reset(p21); //Digital reset for the XBee, 200ns for reset

// Buttons
InterruptIn R_btn(p16);
InterruptIn L_btn(p17);

BusOut lights (LED4,LED3,LED2,LED1);

typedef enum {
    OFF = 0b0000,
    ALL = 0b1111,
    L2  = 0b1100,
    R2  = 0b0011    
} light_configs;

 
int joystick_x, fire;  // global variables to hold values
volatile int current_speed;
volatile bool LOCKED;
const float LED_HOLD_SHORT = .1;
const float LED_HOLD_LONG = .25;

Ticker joystick; // recurring interrupt to get joystick data

/********************
* LED CONTROL FUNCS *
*********************/
void homeLED(bool send) {
    // Tripple blink
    lights = OFF;
    wait(LED_HOLD_SHORT);
    lights = ALL;
    wait(LED_HOLD_SHORT);
    lights = OFF;
    wait(LED_HOLD_SHORT);
    
    lights = ALL;
    wait(LED_HOLD_SHORT);
    lights = OFF;
    wait(LED_HOLD_SHORT);
    
    lights = ALL;
    wait(LED_HOLD_SHORT);
    lights = OFF;
    wait(LED_HOLD_SHORT);
    
    wait(LED_HOLD_SHORT);
    
    // If recieve, don't hold
    if (send) { 
        // Hold until ACK
        lights = ALL;
    }
}

void lockLED(){
    if (LOCKED) {
        lights = ALL;
    } else {
        lights = OFF;
    }
}

void doubleBlinkLED() {
    lights = OFF;
    wait(LED_HOLD_SHORT);
    
    lights = ALL;
    wait(LED_HOLD_LONG);
    lights = OFF;
    wait(LED_HOLD_LONG);
    
    lights = ALL;
    wait(LED_HOLD_LONG);
    lights = OFF;
    wait(LED_HOLD_LONG);
}


/*****************
* JOYSTICK FUNCS *
******************/
void joystick_Int_Handler()
{
    joystick_x = xAxis.read() * 11; // float (0->1) to int (0-1000)
    
    if (!select) {
        LOCKED = !LOCKED;
    }
    
}


/**************************
* DATA SEND/RECIEVE FUNCS *
***************************/

void goHome() {
    homeLED(true);
    
    if (LOCKED) !LOCKED; // Turn off LOCK
    
    xbee.puts("!H\n\r");
    wait(.2);
    
    // Wait for ACK to recall
    while (1) {
        if (xbee.getc() == '!') {
            if (xbee.getc() == 'A') {
                break;
            }
        }
    }
    
    homeLED(false);
}

void calibrate() {
    doubleBlinkLED();
    
    if (LOCKED) !LOCKED; // Turn off LOCK
    
    // Send into calibrate state
    xbee.puts("!C\n\r");
    wait(.2);
    
    lights = L2;
    
    // Wait for Home to send calibrate signal
    while (1) {
        // Home calibration
        if (R_btn) {
            xbee.puts("!C\n\r");
            wait(.2);
            break;
        }
    }
    
    // Wait for ACK to recall on home
    while (1) {
        if (xbee.getc() == '!') {
            if (xbee.getc() == 'A') {
                break;
            }
        }
    }
    
    // Wait for Away to send calibrate signal
    while (1) {
        // Home calibration
        if (R_btn) {
            xbee.puts("!C\n\r");
            wait(.2);
            break;
        }
    }
    
    lights = R2;
    
    // Wait for ACK to recall on away
    while (1) {
        if (xbee.getc() == '!') {
            if (xbee.getc() == 'A') {
                break;
            }
        }
    }
    
    // Wait for ACK to recall on finish calibrate
    while (1) {
        if (xbee.getc() == '!') {
            if (xbee.getc() == 'A') {
                break;
            }
        }
    }
    
    doubleBlinkLED();
}

void lock_state() {
    // LED indicator
    lockLED();
    
    // Toggle lock state
    LOCKED = !LOCKED;
    
    // Send lock command
    xbee.puts("!0L");
    wait(.02); 
}

void send_new_speed(int speed) {
    if (speed > 5) { xbee.printf("!%iL", speed-5); }
    else if (speed == 5) { xbee.printf("!%iL", speed-5); }
    else { xbee.printf("!%iR", 5-speed); }
    wait(.02);
} 
 

int main() 
{
    select.mode(PullUp);
    select.rise(&lock_state);
    L_btn.rise(&goHome);
    R_btn.rise(&calibrate);
    
    // init interrupt, call every .2s
    joystick.attach(joystick_Int_Handler,0.2);
    
    // Print out the variables
    while(1){
        
        // Do nothing if locked -- can still take in interrupts
        if (LOCKED) { continue; }
        
        // Manages speed
        int sampled_speed = joystick_x;  // Get static copy of speed
        
        // If speed changes, send speed update command
        if (current_speed != sampled_speed) {
            send_new_speed(sampled_speed);
        }
        
    }
    
    
}