#include "mbed.h"

Timer t1;

#define Thumb_mult(d,s) __asm {\
        MULS d,s;}
#define Thumb2_mult(d,m,s) __asm {\
        MULS d,m,s;}
#define Thumb_add(d,s) __asm {\
        ADDS d,s;}
#define Thumb2_add(d,n,s) __asm {\
        ADDS d,n,s;}         
#define Thumb_div(d,s) __asm {\
        DIVS d,s;}
#define Thumb2_div(d,n,s) __asm {\
        DIVS d,n,s;}         


int main() {
 
  register uint32_t r0= 0xA;
  register uint32_t r1= 0x3;
  register uint32_t r2= 0x0;
  t1.start();
  Thumb_mult(r1,r0);
  t1.stop();
  printf("the answer is %d\n", r1);
  printf("The time taken for thumb mult was %f seconds\n", t1.read());
  
  r1=0x3;
  t1.start();
  Thumb2_mult(r2,r1,r0);
  t1.stop();
  printf("the answer is %d\n", r2);
  printf("The time taken for thumb2 mult was %f seconds\n", t1.read());
  
  printf("\n");
  t1.start();
  Thumb_add(r1,r0);
  t1.stop();
  printf("the answer is %d\n", r1);
  printf("The time taken for thumb add was %f seconds\n", t1.read());
  
  r1=0x3;
  t1.start();
  Thumb2_add(r2,r1,r0);
  t1.stop();
  printf("the answer is %d\n", r2);
  printf("The time taken for thumb2 add was %f seconds\n", t1.read());
  
  r1 = 0xA;
  printf("\n");
  t1.start();
  Thumb_div(r1,r0);
  t1.stop();
  printf("the answer is %d\n", r1);
  printf("The time taken for thumb div was %f seconds\n", t1.read());
  
  r1=0xA;
  printf("\n");
  t1.start();
  Thumb2_div(r2, r1,r0);
  t1.stop();
  printf("the answer is %d\n", r2);
  printf("The time taken for thumb2 div was %f seconds\n", t1.read());
}
