#include "mbed.h"
//#include "InterruptIn.h"
//#include "Serial.h"

//DECLARATIONS
Serial pc(USBTX, USBRX);
Serial BT(p28,p27);

//Digital Inputs
DigitalIn Sw1(p24); 

//Digital Outputs
DigitalOut DOut1(p25);

//Analog Inputs
AnalogIn AnaInput1(p15);
AnalogIn AnaInput2(p16);

//Analog Outputs
AnalogOut AOutput(p18);

//PWM Outs
PwmOut PWM(p21);

char DisplayMenu(void){
char Key;
    printf("\n\r-----Robotics Test Program -----\n");
    printf("\n\r Type number followed by enter:");
    printf("\n\r 1: Read digital value at XX and write to YY.");
    printf("\n\r 2: Write analog output at XX.");
    printf("\n\r 3: Read analog input at YY and ZZ.");
    printf("\n\r 4: PWM output at XX.");
    printf("\n\r 5: Timer interrupt generation.");
    printf("\n\r 6: External interrupt generation.");
    printf("\n\r 7: Linear optical array test.");
    printf("\n\r 8: Bluetooth communication.");
    printf("\n\r Keypress = "); 
    Key=0x7F & pc.getc();
    wait_ms(100);
    printf("\n\r-------------------------------------");
    printf("\r\n Pressed Key = %c",Key);
    printf("\n\r-------------------------------------");
    return(Key);
}

int SimpleIO(){ 
    bool z;
    z = Sw1;
    DOut1 = z;
    printf("\r\n Logic Value = %x",z);
    DOut1 = Sw1;
    return 0;
}
    
int AOut(){
    char Key;
    printf("\n\rEnter a value");
    printf("\n\r Keypress = ");
    Key=0x7F & pc.getc();
    printf("\n\r-------------------------------------");
    printf("\r\n Pressed Key = %c",Key);
    printf("\n\r-------------------------------------");
    float K = Key;
    AOutput.write(K/128);
    printf("\n\rK = %2.2f",K);
    return 0;
}
    
int fAnalogIn(){
    printf("\n\r Pin 15 Input = %1.4f volts\n", AnaInput1.read()*3.3f);
    AOutput.write(AnaInput1.read());
    printf("\n\r Pin 16 Output = %1.4f volts\n", AnaInput2.read()*3.3f);
    return 0;
}

int PWMOut(){
    
    //Specify Period First
    char T[4] = "500";
    char PW[4] = "250";
    printf("\n\r\n\r-----Robotics PWM Options-----");
    
    printf("\n\rEnter a Period in microSeconds (max 999):");
    pc.gets(T,4);
    long int P = strtol(T,NULL,10);
    PWM.period_us(P);
    
    printf("\n\rEnter a Pulse Width in microSeconds (max 999):");
    pc.gets(PW,4);
    long int W = strtol(PW,NULL,10);
    PWM.pulsewidth_us(W);
    
    printf("\n\rPeriod in uS: %i", P);
    printf("\n\rPulse Width in uS: %i", W);
    float R = W/P;
    printf("\n\rDuty Cycle: %3.3f", R);
    
    
 return 0;   
}

int ExternalIntInit(){//initialize an external interrupt that causes an LED to toggle its state each
//time an external interrupt is detected.

return 0;
}

int TimerIntInit()
{
    
    return 0;
    }

int LinearOpticalArrayTest(){//repeatedly generates scans of the TSL1401 with a fixed delay between scans
int i;
do {
 //scan(ScanData); // Dummy scan
 //wait_us(IntegrationTime);
 //scan(ScanData);
 if (pc.readable()){
 char x=pc.getc();
 if (x=='q') break;
  else if (x=='i')
  {
  
  
  }
  else if(x=='l') 
  {
      //Display pixel values at the terminal
  }
 for(i=0; i<128; i=i+1) pc.printf("\n\n\r%d"/*, ScanData[i]*/);
 }
}while(1);
pc.printf("\n\n\rTerminating clocking sequence for linear optical array.\n\r");
return 0;
}

int BlueToothTest(){
    char x;
    BT.baud(9600);
    do{
        if (pc.readable()) {
            x = pc.getc(); //read keypress
            if(x == 13){
                BT.putc('\n'); //send to pc/mobile
                pc.putc('\n'); //echo to pc
                BT.putc('\r'); //send to pc/mobile
                pc.putc('\r'); //echo to pc
                }
            else{
                BT.putc(x); //send to pc/mobile
                pc.putc(x); //echo to pc
            }
            }
    }while(x != 'q');
    return 0;
}

void scan(short ScanData[]) {
int j;
 //LoaSI=1;
 //LoaCLK=1;
 //LoaSI=0;
 for(j=0;j<128;j=j+1){
 //ScanData[j]=LoaAnalogIn.read_u16();
 //LoaCLK=0; //delay_us(1);
 //LoaCLK=1;
 }
 //LoaCLK=0;
}

int main() {
char Key;
//Initialize();
while(1) {
 Key=DisplayMenu();
 if(Key=='1') SimpleIO();                       //LAB 2.2
 else if(Key=='2') AOut();                       //LAB 2.3
 else if(Key=='3') fAnalogIn();                 //LAB 2.4
 else if(Key=='4') PWMOut();                   //LAB 2.5
 else if(Key=='5') TimerIntInit();              //LAB 2.6
 else if(Key=='6') ExternalIntInit();           //LAB 2.7
 else if(Key=='7') LinearOpticalArrayTest();    //LAB 2.8
 else if(Key=='8') BlueToothTest();             //LAB 2.9
 else printf("\r\nInvalid keypress entry.\r\n");
}
}
