//  4180 Lab 1, Part 9
//  Gregory Lanier

#include "mbed.h"

// I/O
AnalogOut waveOut(p18); // Sine wave out with p18

// Global Vars
const double pi = 3.141592653589793238462;

int main() {
    
    // Vars
    float sample = 0.0f;
    float sampleScaled = 0.0f;
    float cycle[20];
    int element = 0;
    
    // Precalculate the sine wave value for one full cycle
    for (int degree = 0; degree < 20; degree++ ) {
        sample = sin((pi * degree*18) / 180.0f);   // Receive a sample from -1.0 to 1.0
        sampleScaled = (sample*0.5f) + 0.5f;    // Scale the value from 0.0 to 1.0
        cycle[element] = sampleScaled;
        element++;
    }
    
    // Loop output forever
    while(1) {
        // Output a single loop
        for (int sampleOut = 0; sampleOut < 20; sampleOut++) {
            waveOut.write(cycle[sampleOut]); // Output scaled sample value
        }       
    }
}

// Frequency: 28 kHz
