 //  4180 Lab 1, Part 2
//  Gregory Lanier

#include "mbed.h"
#include "PinDetect.h"

/*
    This program lights up a built in LED and enables dimming with two push buttons.
*/

// Global Vars
float brightness = 0.5f;   // Initial brightness 1/2 power

// I/O
PinDetect   dimButton(p8);      // Make LED dimmer with p8 button
PinDetect   brightButton(p9);   // Make LED brighter with p9 button
PwmOut  mbedLED(LED1);          // LED1 built into Mbed

// Dim Callback
void dim_callback(void) {
    brightness -= 0.1f;
}

// Brighten Callback
void bright_callback(void) {
    brightness += 0.1f;
}

int main()
{
    // Button Mode Set
    dimButton.mode(PullUp);    
    brightButton.mode(PullUp);
    wait(0.01);
    
    // Setuo button callbacks
    dimButton.attach_deasserted(&dim_callback);    
    brightButton.attach_deasserted(&bright_callback);
    
    // Start sampling button inputs using interrupts
    dimButton.setSampleFrequency();
    brightButton.setSampleFrequency();
    
    // Logic Loop
    while(1) {
        mbedLED = brightness;   // Update brightness
        }
}