#include "mbed.h"
#include "rtos.h"
#include "Speaker.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

char setting = '1';

BusOut myled(LED1,LED2,LED3,LED4);

Serial blue(p13,p14);

AnalogOut DACout(p18);

wave_player waver(&DACout);

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

Mutex stdio_mutex;
Mutex get_mutex;

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;

PwmOut  rLED(p21);  // Light up Red LED with p21
PwmOut  gLED(p22);  // Light up Green LED with p22
PwmOut  bLED(p23);  // Light up Blue LED with p23

Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;

Semaphore semled(0);
Semaphore semlcd1(0);
Semaphore semlcd2(0);
Semaphore sem_check(0);

///* The Terminator 53. Coming to theatres this summer!!!!!! */
//void the_terminator()
//{
//
//}

/* Threads */
void led_thread()
{
    while(1) {
        /* Setting 1: Red and Blue */
        if(setting == '1') {
            bLED = 0;
            rLED = 1;
            gLED = 0;
            //Thread::wait(750);
            semled.wait();
            rLED = 0;
            bLED = 1;
            gLED = 0;
            //Thread::wait(750);
            semled.wait();
        }

        /* Setting 2: Purple and Green */
        else if (setting == '2') {
            bLED = 1;
            rLED = 1;
            gLED = 0;
            //Thread::wait(750);
            semled.wait();
            rLED = 0;
            bLED = 0;
            gLED = 1;
            //Thread::wait(750);
            semled.wait();
        }

        /* Setting 3: Yellow and Cyan*/
        else if(setting == '3') {
            bLED = 0;
            rLED = 1;
            gLED = 1;
            //Thread::wait(750);
            semled.wait();
            rLED = 0;
            bLED = 1;
            gLED = 1;
            //Thread::wait(750);
            semled.wait();
        }

        /* Setting 4: Black and White */
        else if(setting == '4') {
            bLED = 0;
            rLED = 0;
            gLED = 0;
            //Thread::wait(750);
            semled.wait();
            rLED = 1;
            bLED = 1;
            gLED = 1;
            //Thread::wait(750);
            semled.wait();
        }

    }
}

void speaker_thread()
{
    while(1) {

        /* Setting 1: WeeWoo Wagon */
        if(setting == '1') {
            FILE *wave_file;
            wave_file=fopen("/sd/WEEWOO.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
        }
        
        /* Setting 2: */
        if(setting == '2') {
            FILE *wave_file;
            wave_file=fopen("/sd/dank_export.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
        }
        
        /* Setting 3: */
        if(setting == '3') {
            FILE *wave_file;
            wave_file=fopen("/sd/crickets_exp.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
        }
        
        /* Setting 4: */
        if(setting == '4') {
            FILE *wave_file;
            wave_file=fopen("/sd/static_exp.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
        }

    }
}

void lcd1_thread()
{
    while(1) {

        /* Setting 1: Red */
        if(setting == '1') {
            // Top Red Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, RED);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            semled.release();
            semlcd2.release();
            // Top Black Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, BLACK);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            sem_check.release();
            semlcd1.wait();
            semled.release();
            semlcd2.release();
        }

        /* Setting 2: Purple */
        else if(setting == '2') {
            // Top Red Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, 0xFF00FF);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            semled.release();
            semlcd2.release();
            // Top Black Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, BLACK);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            sem_check.release();
            semlcd1.wait();
            semled.release();
            semlcd2.release();
        }

        /* Setting 3: Yellow */
        else if(setting == '3') {
            // Top Red Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, 0xFFFF00);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            semled.release();
            semlcd2.release();
            // Top Black Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, BLACK);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(750);
            sem_check.release();
            semlcd1.wait();
            semled.release();
            semlcd2.release();
        }

        /* Setting 4: Black and White */
        else if(setting == '4') {
            // Top Red Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, BLACK);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(250);
            semled.release();
            semlcd2.release();
            // Top Black Box
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 0, 127, 63, WHITE);
            semlcd2.release();
            //stdio_mutex.unlock();
            Thread::wait(250);
            sem_check.release();
            semlcd1.wait();
            semled.release();
            semlcd2.release();
        }
    }
}

void lcd2_thread()
{
    while(1) {

        /* Setting 1: Blue */
        if(setting == '1') {
            // Bottom Black Box
            semlcd2.wait();
            //stdio_mutex.lock();
            uLCD.filled_rectangle(0, 63, 127, 127, BLACK);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
            // Bottom Blue Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, BLUE);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
        }

        /* Setting 2: Green */
        else if(setting == '2') {
            // Bottom Black Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, BLACK);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
            // Bottom Blue Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, GREEN);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
        }

        /* Setting 3: Cyan */
        else if(setting == '3') {
            // Bottom Black Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, BLACK);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
            // Bottom Blue Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, 0x00FFFF);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
        }

        /* Setting 4: Black and White */
        else if(setting == '4') {
            // Bottom Black Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, BLACK);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
            // Bottom Blue Box
            //stdio_mutex.lock();
            semlcd2.wait();
            uLCD.filled_rectangle(0, 63, 127, 127, WHITE);
            //stdio_mutex.unlock();
            //Thread::wait(750);
            semlcd2.wait();
        }
    }
}


int main()
{
    rLED = 0;
    gLED = 0;
    bLED = 0;

    /* Wait for user to press a setting button */
    char bnum=0;
    while(1) {
        if (blue.readable() && blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
                if ((bnum>='1')&&(bnum<='4')) { //is a number button 1..4
                    setting = bnum;// Change setting based on button input to set start setting. Check for chars
                    break; //turn on/off that num LED
                }
            }
        }
    }

    /* Start all threads */
    thread1.start(led_thread);
    thread2.start(speaker_thread);
    thread3.start(lcd1_thread);
    thread4.start(lcd2_thread);

    /* Infinite Loop, let threads run */
    while (1) {

        sem_check.wait();

        if (blue.readable() && blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                char bnum = blue.getc(); //button number
                if ((bnum>='1')&&(bnum<='4')) { //is a number button 1..4
                    setting = bnum;// Change setting based on button input to set start setting. Check for chars
                }
            }
        }

        semlcd1.release();
    }
}
