#include "mbed.h"
#include "ultrasonic.h"
#include "uLCD_4DGL.h"  //lcd

//lcd
uLCD_4DGL uLCD(p13,p14,p30); // serial tx, serial rx, reset pin;

 void dist(int distance)
{
    //put code here to execute when the distance has changed
    //uLCD.printf("Distance = %ld ft\r\n", distance);  
    uLCD.printf("Distance = %d ft\r\n", distance);  
    //printf("Distance %d mm\r\n", distance);
}

ultrasonic mu(p6, p7, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes

int main()
{
    mu.startUpdates();//start measuring the distance
    while(1)
    {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
         
        
    }
}
