#include "mbed.h"
#include "mbed_rpc.h"
#include "uLCD_4DGL.h"
#include <ctype.h>
#include "RGB_LED.h"
 
//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
Serial pc(USBTX, USBRX);
PinName tx, rx, rst;
RGBLed myRGBled(p22,p23,p24);
uLCD_4DGL uLCD(p28, p27, p29);
char text;
//string screen;
 
void clearLCD(Arguments *in, Reply *out);
RPCFunction rpcClear(&clearLCD, "clearLCD");

void printLCDAndLightRGB(Arguments *in, Reply *out);
RPCFunction rpcPrintLCDAndLightRGB(&printLCDAndLightRGB, "printLCDAndLightRGB");
  
int main() {
 
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}

void clearLCD(Arguments *in, Reply *out)
{
    uLCD.cls();
}

void printLCDAndLightRGB(Arguments *in, Reply *out)
{
        uLCD.cls();
        char * text = in->getArg<char *>();
        int value = strlen(text);
        if(text[0] == '1'){
          myRGBled.write(0,1.0f,0);
          uLCD.printf("Tweet is found!\n");
          uLCD.printf("\n");
        } else if(text[0] == '0'){
          myRGBled.write(0,0,1.0f);
        }
        text[0] = '-';
        for(int i = 0; i< value; i++) {
            if(text[i] == '|') {
               text[i] = ' ';   
            }
        }
        uLCD.printf(text);
 }