#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "RGB_LED.h"
#include "SDFileSystem.h"
#include "wave_player.h"


DigitalOut led1(LED1);
DigitalOut led2(LED2);
Thread thread;
Thread thread2;
Thread thread3;
Thread thread4;
Mutex stdio_mutex;
AnalogOut DACout(p18); 
SDFileSystem sd(p5, p6, p7, p8, "sd");
Serial bluemod(p9,p10);
wave_player waver(&DACout);
uLCD_4DGL uLCD(p28,p27,p29);
RGBLed myRGBled(p22,p23,p24);
char bred=0;
char bgreen=0;
char bblue=0;
int bnum = 0;
int red=0;
int green=0;
int blue = 0;
void printName() {
  stdio_mutex.lock();
  uLCD.text_string("LETS DANCE!",1,14, FONT_7X8, RED);
  Thread::wait(1000);
  uLCD.text_string("LETS DANCE!",1,14, FONT_7X8, BLACK);
  uLCD.text_string("TURN UP!",1,14,FONT_7X8, BLUE); 
  stdio_mutex.unlock();
 }
void colorULCD() {
  stdio_mutex.lock();
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,RED);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,BLUE);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,RED);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20, 255*65536+165*256+0);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,255*65536+255*256+0);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,GREEN);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,BLUE);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,75*65536+0*256+130);
  Thread::wait(500);
  uLCD.line(60,80,60,0,128*65536+128*256+128);
  uLCD.filled_circle(60,60,20,128*65536+0*256+128);
  stdio_mutex.unlock();
 }
 
 void RGB_LED() {
  
   if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                stdio_mutex.lock();
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) {
                     //checksum OK?
                    stdio_mutex.unlock();
                    red = bred/255.0; //send new color to RGB LED PWM outputs
                    green = bgreen/255.0;
                    blue = bblue/255.0;
                    myRGBled.write(red,green,blue);
                }
            }
        } 
    }
  void Speaker_Function() {
     FILE *wave_file;
     
     if (bluemod.getc()=='!') {
            if (bluemod.getc()=='B') { //button data
                stdio_mutex.lock();
                bnum = bluemod.getc();
                stdio_mutex.unlock();
                if (bnum=='1') { //is a number button 1..4
                     wave_file=fopen("/sd/wavfiles/trapman.wav","r");
                     waver.play(wave_file);
                      fclose(wave_file);  //turn on/off that num LED
            }
        }
     }
  }
  //myRGBled.write(1.0f, 0, 0); // turn the RGB LED red 
  //Thread::wait(500); // wait for 1 second 
  //myRGBled.write(0, 0, 255); // turn the RGB LED blue 
  //Thread::wait(500); // wait for 1 second 
  // Example blended myRGBled.writes: 
  //myRGBled.write(255,0,0); // turn the RGB LED red 
  //Thread::wait(500); // wait for 1 second 
  //myRGBled.write(237,109,0); // turn the RGB LED orange 
  //Thread::wait(500); // wait for 1 second 
  //myRGBled.write(255,215,0); // turn the RGB LED yellow 
  //Thread::wait(500); // wait for 1 second 
  //myRGBled.write(34,139,34); // turn the RGB LED green 
  //Thread::wait(500); // wait for 1 second 
  //myRGBled.write(0,0,255); // turn the RGB LED blue 
  //Thread::wait(050); // wait for 1 second
  //myRGBled.write(0,46,90); // turn the RGB LED indigo 
  //Thread::wait(500); // wait for 1 second
  //myRGBled.write(128,0,128); // turn the RGB LED purple 
void uLCD_thread1() {
    while (true) {
    colorULCD();
    Thread::wait(500);
    }
        
}
void uLCD_thread2() {
    while (true) {
    printName();
    Thread::wait(250);    
    }
    
 }
void RGB_thread3(){
    while (true){
    RGB_LED();
    Thread::wait(100);
    }
  }
void Speaker_Thread(){
    while(true){
    Speaker_Function();
    Thread::wait(250);
    }
}
int main() {
   // thread.start(uLCD_thread1);
   thread2.start(uLCD_thread2);
   thread3.start(RGB_thread3);
   thread4.start(Speaker_Thread);
  //  FILE *wave_file;
   // wave_file=fopen("/sd/wavfiles/trapman.wav","r");
   // waver.play(wave_file);
   // fclose(wave_file);    
}
 


