#include "mbed.h"
#include "PinDetect.h"
#include "RGB_LED.h"

RGBLed myRGBled(p22,p23,p24);
PinDetect pb1(p16);
PinDetect pb2(p17);
DigitalIn switchInputRed(p13);
DigitalIn switchInputBlue(p14);
DigitalIn switchInputGreen(p15);


float illuminateRed = 0.0f;
float illuminateBlue = 0.0f;
float illuminateGreen = 0.0f;
bool greenOn =false;
bool blueOn = false;
bool redOn = false;


void pb1_dim_callback (void) {
    if(redOn && illuminateRed > 0.0f){
        illuminateRed -= 0.1f;    
    }
    if(greenOn && illuminateGreen > 0.0f){
        illuminateGreen -= 0.1f;    
    }
    if(blueOn && illuminateBlue > 0.0f) {
        illuminateBlue -= 0.1f;    
    }
 }
void pb2_bright_callback (void) {
    if(redOn && illuminateRed <= 1.0f){
        illuminateRed += 0.1f;    
    }
    if(greenOn && illuminateGreen <= 1.0f){
        illuminateGreen += 0.1f;    
    }
    if(blueOn && illuminateBlue <= 1.0f) {
        illuminateBlue += 0.1f;    
    }
  }
int main() {
        switchInputRed.mode(PullUp);
        switchInputGreen.mode(PullUp);
        switchInputBlue.mode(PullUp);
        pb1.mode(PullUp);
        pb2.mode(PullUp);
        wait(.01);
        
        pb1.attach_deasserted(&pb1_dim_callback);
        pb2.attach_deasserted(&pb2_bright_callback);
        
        pb1.setSampleFrequency();
        pb2.setSampleFrequency();
        
        while(1) {
         redOn = !switchInputRed;
         blueOn = !switchInputBlue;
         greenOn = !switchInputGreen;
         myRGBled.write(illuminateRed,illuminateGreen,illuminateBlue);
         wait(.1);
        }
}
