#include "mbed.h"
//Solenoid Hello World
DigitalOut myled(LED1);
//Non blocking with auto off delay using timer interrupt setup by class
class Solenoid
{
public:
    Solenoid (PinName pin, float delay=0.5);
    void write(bool state);
    Solenoid& operator= (bool value);
 
private:
    void Solenoid_Off_Int();
    DigitalOut _pin;
    Timeout tint;
    float ontime;
};
Solenoid::Solenoid(PinName pin, float delay) : _pin(pin), ontime(delay)
{
    _pin=0;
}
void Solenoid::Solenoid_Off_Int()
{
    _pin=0;//timer interrupt routine to auto turn off solenoid
}
void Solenoid::write(bool value)
{
    _pin = value;
    if (value!=0) //do auto off with timer interrupt
        tint.attach(this,&Solenoid::Solenoid_Off_Int,ontime);//setup a timer interrupt
}
Solenoid& Solenoid::operator= (bool value)
{
    write(value);
    return *this;
}
 
Solenoid mySolenoid(p21);
int main()
{
    while(1) {
        mySolenoid = 1; //ON with timer auto off
        myled = 1;
        wait(.5); //just for LEDs - solenoid turns off with timer interrupt
        myled = 0;
        wait(2.0);
    }
}