
#include "mbed.h"
#include "Motor.h"
#include "rtos.h"

#define SD_DBG             1

#include "SDFileSystem.h"
SDFileSystem sd(p5, p6, p7, p29, "sd");


#include "wave_player.h"
AnalogOut DACout(p18);
wave_player waver(&DACout);

#include "XNucleo53L0A1.h"
#include <stdio.h>
Serial pc(USBTX,USBRX);
DigitalOut shdn(p26);

//I2C sensor pins
#define VL53L0_I2C_SDA   p28
#define VL53L0_I2C_SCL   p27
static XNucleo53L0A1 *board=NULL;
DigitalOut myled (LED2);
Serial blue(p9,p10);
Motor RW(p22, p13, p12); // pwm, fwd, rev
Motor LW(p21, p8, p11); // pwm, fwd, rev
Thread lidar;
Thread siren;
uint32_t distance;
int level = 8; //Volume level is turned off


//speaker thread
void t3(){
   
    while(1){
               
    FILE *wave_file=fopen("/sd/LoudSound.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    
}
}

//lidar thread
void t2() {
    
    int status;
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);
    shdn = 0; //must reset sensor for an mbed reset to work
    Thread::wait(100);
    //lidar power off
    shdn = 1;
    Thread::wait(100);
    /* init the 53L0A1 board with default values */
    status = board->init_board();
    while (status) {
        pc.printf("Failed to init board! \r\n");
        status = board->init_board();
    }
    //loop taking and printing distance
    while (1) {
        status = board->sensor_centre->get_distance(&distance);
        if (status == VL53L0X_ERROR_NONE) {
            pc.printf("D=%ld mm\r\n", distance);
            if(distance > 240) level = 8;
            if(distance < 90) level = 0;
            if (distance >=90 && distance <=240){
                 int value=floor(static_cast<double>(8*(distance-90)/150));
                 if(value >=0 && value<=8){
                     level=value;
                 } 
            }
        }
    myled=!myled;
    Thread::wait(500);
    }
    
    }


//bot movement using bluetooth thread
int main()
{
    char previousButton='0';
    char current;
    myled=0;
    pc.printf("in main\n\r");
    lidar.start(t2);
    siren.start(t3);
    char bnum=0;
    char bhit=0;
    while(1) {
         
    if(blue.readable()==1){
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                current=bnum;  
                previousButton = current; 
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { 
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                RW.speed(1);
                            } else {
                                //add release code here
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                RW.speed(0);
                                LW.speed(0);
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                RW.speed(1.0);
                                LW.speed(1.0);  
                            } else {
                                RW.speed(0); 
                                LW.speed(0); 
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                RW.speed(-1.0);
                                LW.speed(-1.0);  
                                //add hit code here
                            } else {
                                RW.speed(0);
                                LW.speed(0);
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                RW.speed(-1.0);
                                LW.speed(1.0);
                            } else {
                                RW.speed(0);
                                LW.speed(0);
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                RW.speed(1.0);
                                LW.speed(-1.0);
                            } else {
                                RW.speed(0);
                                LW.speed(0);
                            }
                            break;
                        default:
                            break;
                    }
                    }
                    }
                }
          
            }
           
            Thread::yield();
            
        }
    }
   } 