#include "mbed.h"

PwmOut GREEN(p22); // normal LED
PwmOut BLUE(p21); // normal LED

AnalogIn AinBLUE(p20);
AnalogIn AinGREEN(p19);


int main()
{
    float dcBLUE; // 50% duty cycle
    float dcGREEN;

    GREEN.period(0.01f);      // 0.01 second period
    BLUE.period(0.01f);      // 0.01 second period

    while (1) {
        dcBLUE = 0.5*AinBLUE;
        dcGREEN = 0.5*AinGREEN;
        BLUE.write(dcBLUE);
        GREEN.write(dcGREEN);
        wait(0.1);
    }
    return 0;
}